/*
 * Decompiled with CFR 0.152.
 */
package net.semanticmetadata.lire.utils;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;

public class SerializationUtils {
    public static int toInt(byte[] data) {
        if (data == null || data.length != 4) {
            return 0;
        }
        return (0xFF & data[0]) << 24 | (0xFF & data[1]) << 16 | (0xFF & data[2]) << 8 | (0xFF & data[3]) << 0;
    }

    public static byte[] toBytes(int data) {
        return new byte[]{(byte)(data >> 24 & 0xFF), (byte)(data >> 16 & 0xFF), (byte)(data >> 8 & 0xFF), (byte)(data >> 0 & 0xFF)};
    }

    public static byte[] toBytes(long data) {
        return new byte[]{(byte)(data >> 56 & 0xFFL), (byte)(data >> 48 & 0xFFL), (byte)(data >> 40 & 0xFFL), (byte)(data >> 32 & 0xFFL), (byte)(data >> 24 & 0xFFL), (byte)(data >> 16 & 0xFFL), (byte)(data >> 8 & 0xFFL), (byte)(data >> 0 & 0xFFL)};
    }

    public static long toLong(byte[] data) {
        if (data == null || data.length != 8) {
            return 0L;
        }
        return (long)(0xFF & data[0]) << 56 | (long)(0xFF & data[1]) << 48 | (long)(0xFF & data[2]) << 40 | (long)(0xFF & data[3]) << 32 | (long)(0xFF & data[4]) << 24 | (long)(0xFF & data[5]) << 16 | (long)(0xFF & data[6]) << 8 | (long)(0xFF & data[7]) << 0;
    }

    public static byte[] toByteArray(int[] data) {
        byte[] result = new byte[data.length * 4];
        for (int i = 0; i < data.length; ++i) {
            byte[] tmp = SerializationUtils.toBytes(data[i]);
            System.arraycopy(tmp, 0, result, i * 4, 4);
        }
        return result;
    }

    public static int[] toIntArray(byte[] data) {
        int[] result = new int[data.length / 4];
        byte[] tmp = new byte[4];
        for (int i = 0; i < result.length; ++i) {
            System.arraycopy(data, i * 4, tmp, 0, 4);
            result[i] = SerializationUtils.toInt(tmp);
        }
        return result;
    }

    public static int[] toIntArray(byte[] in, int offset, int length) {
        int[] result = new int[length >> 2];
        byte[] tmp = new byte[4];
        for (int i = 0; i < length >> 2; ++i) {
            System.arraycopy(in, offset + i * 4, tmp, 0, 4);
            result[i] = SerializationUtils.toInt(tmp);
        }
        return result;
    }

    public static byte[] toBytes(float data) {
        return SerializationUtils.toBytes(Float.floatToRawIntBits(data));
    }

    public static float toFloat(byte[] data) {
        return Float.intBitsToFloat(SerializationUtils.toInt(data));
    }

    public static byte[] toByteArray(float[] data) {
        byte[] result = new byte[data.length * 4];
        for (int i = 0; i < data.length; ++i) {
            byte[] tmp = SerializationUtils.toBytes(data[i]);
            System.arraycopy(tmp, 0, result, i * 4, 4);
        }
        return result;
    }

    public static float[] toFloatArray(byte[] data) {
        float[] result = new float[data.length / 4];
        byte[] tmp = new byte[4];
        for (int i = 0; i < result.length; ++i) {
            System.arraycopy(data, i * 4, tmp, 0, 4);
            result[i] = SerializationUtils.toFloat(tmp);
        }
        return result;
    }

    public static float[] toFloatArray(byte[] in, int offset, int length) {
        float[] result = new float[length / 4];
        byte[] tmp = new byte[4];
        for (int i = offset; i < length / 4; ++i) {
            System.arraycopy(in, (i - offset) * 4 + offset, tmp, 0, 4);
            result[i] = SerializationUtils.toFloat(tmp);
        }
        return result;
    }

    public static byte[] toBytes(double data) {
        return SerializationUtils.toBytes(Double.doubleToLongBits(data));
    }

    public static double toDouble(byte[] data) {
        return Double.longBitsToDouble(SerializationUtils.toLong(data));
    }

    public static byte[] toByteArray(double[] data) {
        byte[] result = new byte[data.length * 8];
        for (int i = 0; i < data.length; ++i) {
            byte[] tmp = SerializationUtils.toBytes(data[i]);
            System.arraycopy(tmp, 0, result, i * 8, 8);
        }
        return result;
    }

    public static double[] toDoubleArray(byte[] data) {
        double[] result = new double[data.length / 8];
        byte[] tmp = new byte[8];
        for (int i = 0; i < result.length; ++i) {
            System.arraycopy(data, i * 8, tmp, 0, 8);
            result[i] = SerializationUtils.toDouble(tmp);
        }
        return result;
    }

    public static double[] castToDoubleArray(byte[] data) {
        double[] result = new double[data.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = data[i];
        }
        return result;
    }

    public static double[] toDoubleArray(byte[] data, int offset, int length) {
        double[] result = new double[length / 8];
        byte[] tmp = new byte[8];
        for (int i = 0; i < result.length; ++i) {
            System.arraycopy(data, i * 8 + offset, tmp, 0, 8);
            result[i] = SerializationUtils.toDouble(tmp);
        }
        return result;
    }

    public static String arrayToString(int[] array) {
        return Arrays.toString(array).replace('[', ' ').replace(']', ' ').replace(',', ' ');
    }

    public static double[] doubleArrayFromString(String data) {
        double[] result = null;
        LinkedList<Double> tmp = new LinkedList<Double>();
        data = data.replace('[', ' ');
        data = data.replace(']', ' ');
        data = data.replace(',', ' ');
        StringTokenizer st = new StringTokenizer(data);
        while (st.hasMoreTokens()) {
            tmp.add(Double.parseDouble(st.nextToken()));
        }
        result = new double[tmp.size()];
        int i = 0;
        for (Double next : tmp) {
            result[i] = next;
            ++i;
        }
        return result;
    }

    public static double[] toDoubleArray(float[] d) {
        double[] result = new double[d.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = d[i];
        }
        return result;
    }

    public static double[] toDoubleArray(int[] ints) {
        double[] result = new double[ints.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = ints[i];
        }
        return result;
    }

    public static double[] toDoubleArray(String data) {
        LinkedList<Double> dl = new LinkedList<Double>();
        StringTokenizer st = new StringTokenizer(data);
        while (st.hasMoreTokens()) {
            dl.add(Double.parseDouble(st.nextToken()));
        }
        double[] result = new double[dl.size()];
        int count = 0;
        Iterator iterator = dl.iterator();
        while (iterator.hasNext()) {
            double next;
            result[count] = next = ((Double)iterator.next()).doubleValue();
            ++count;
        }
        return result;
    }

    public static String toString(double[] data) {
        StringBuilder sb = new StringBuilder(data.length << 2);
        for (int i = 0; i < data.length; ++i) {
            sb.append(data[i]);
            sb.append(' ');
        }
        return sb.toString();
    }

    public static String toString(byte[] data) {
        StringBuilder sb = new StringBuilder(data.length << 2);
        for (int i = 0; i < data.length; ++i) {
            sb.append(data[i]);
            sb.append(' ');
        }
        return sb.toString();
    }

    public static String toHex(byte[] data) {
        StringBuilder sb = new StringBuilder(data.length << 2);
        for (int i = 0; i < data.length; ++i) {
            sb.append(String.format("%02X ", data[i]));
        }
        return sb.toString().trim();
    }

    public static List<double[]> readCodeBook(InputStream in) {
        LinkedList<double[]> result = null;
        try {
            BufferedReader br = new BufferedReader(new InputStreamReader(in));
            String line = null;
            double[] buffer = new double[1024];
            int numDimensions = 0;
            result = new LinkedList<double[]>();
            while ((line = br.readLine()) != null) {
                String[] d = line.split("\\s+");
                numDimensions = 0;
                for (int i = 0; i < d.length; ++i) {
                    if (d[i].length() <= 0) continue;
                    buffer[numDimensions] = Double.parseDouble(d[i]);
                    ++numDimensions;
                }
                double[] r = new double[numDimensions];
                System.arraycopy(buffer, 0, r, 0, numDimensions);
                result.add(r);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return result;
    }

    public static void writeCodeBook(OutputStream out, List<double[]> codeBook) throws IOException {
        String tab = "\t";
        String enter = "\n";
        for (double[] doubles : codeBook) {
            for (int i = 0; i < doubles.length; ++i) {
                out.write(Double.toString(doubles[i]).getBytes());
                if (i < doubles.length - 1) {
                    out.write(tab.getBytes());
                    continue;
                }
                out.write(enter.getBytes());
            }
        }
    }
}

