/*
 * Decompiled with CFR 0.152.
 */
package com.goebl.simplify;

import com.goebl.simplify.AbstractSimplify;
import com.goebl.simplify.Point;
import com.goebl.simplify.PointExtractor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Simplify<T>
extends AbstractSimplify<T> {
    private final PointExtractor<T> pointExtractor;

    public Simplify(T[] sampleArray) {
        super(sampleArray);
        this.pointExtractor = new PointExtractor<T>(){

            @Override
            public double getX(T point) {
                return ((Point)point).getX();
            }

            @Override
            public double getY(T point) {
                return ((Point)point).getY();
            }
        };
    }

    public Simplify(T[] sampleArray, PointExtractor<T> pointExtractor) {
        super(sampleArray);
        this.pointExtractor = pointExtractor;
    }

    @Override
    public double getSquareDistance(T p1, T p2) {
        double dx = this.pointExtractor.getX(p1) - this.pointExtractor.getX(p2);
        double dy = this.pointExtractor.getY(p1) - this.pointExtractor.getY(p2);
        return dx * dx + dy * dy;
    }

    @Override
    public double getSquareSegmentDistance(T p0, T p1, T p2) {
        double x1 = this.pointExtractor.getX(p1);
        double y1 = this.pointExtractor.getY(p1);
        double x2 = this.pointExtractor.getX(p2);
        double y2 = this.pointExtractor.getY(p2);
        double x0 = this.pointExtractor.getX(p0);
        double y0 = this.pointExtractor.getY(p0);
        double dx = x2 - x1;
        double dy = y2 - y1;
        if (dx != 0.0 || dy != 0.0) {
            double t = ((x0 - x1) * dx + (y0 - y1) * dy) / (dx * dx + dy * dy);
            if (t > 1.0) {
                x1 = x2;
                y1 = y2;
            } else if (t > 0.0) {
                x1 += dx * t;
                y1 += dy * t;
            }
        }
        dx = x0 - x1;
        dy = y0 - y1;
        return dx * dx + dy * dy;
    }
}

