/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spring.autoconfigure.datastore;

import com.google.cloud.datastore.Key;
import com.google.cloud.spring.data.datastore.core.mapping.DatastoreDataException;
import com.google.cloud.spring.data.datastore.core.mapping.DatastoreMappingContext;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.util.Optional;
import org.springframework.data.mapping.PersistentEntity;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.rest.webmvc.spi.BackendIdConverter;

public class DatastoreKeyIdConverter
implements BackendIdConverter {
    private final DatastoreMappingContext datastoreMappingContext;

    public DatastoreKeyIdConverter(DatastoreMappingContext datastoreMappingContext) {
        this.datastoreMappingContext = datastoreMappingContext;
    }

    public Serializable fromRequestId(String s, Class<?> clazz) {
        try {
            return Key.fromUrlSafe((String)URLDecoder.decode(s, Charset.defaultCharset().name()));
        }
        catch (UnsupportedEncodingException e) {
            throw new DatastoreDataException("Could not decode URL key param: " + s);
        }
    }

    public String toRequestId(Serializable serializable, Class<?> clazz) {
        return ((Key)serializable).toUrlSafe();
    }

    public boolean supports(Class<?> entityType) {
        return Optional.ofNullable(this.datastoreMappingContext.getPersistentEntity(entityType)).map(PersistentEntity::getIdProperty).map(PersistentProperty::getType).map(clz -> clz.equals(Key.class)).orElse(false);
    }
}

