/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spring.autoconfigure.trace.pubsub;

import com.google.api.core.ApiFuture;
import com.google.cloud.spring.autoconfigure.trace.pubsub.PubSubTracing;
import com.google.pubsub.v1.PullResponse;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

final class TracingApiFuturePullResponse
implements ApiFuture<PullResponse> {
    private final ApiFuture<PullResponse> delegate;
    private final String subscriptionName;
    private final PubSubTracing pubSubTracing;

    TracingApiFuturePullResponse(ApiFuture<PullResponse> delegate, PubSubTracing pubSubTracing, String subscriptionName) {
        this.delegate = delegate;
        this.subscriptionName = subscriptionName;
        this.pubSubTracing = pubSubTracing;
    }

    public PullResponse get() throws InterruptedException, ExecutionException {
        return this.pubSubTracing.tracePullResponse((PullResponse)this.delegate.get(), this.subscriptionName);
    }

    public PullResponse get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        return this.pubSubTracing.tracePullResponse((PullResponse)this.delegate.get(timeout, unit), this.subscriptionName);
    }

    public void addListener(Runnable runnable, Executor executor) {
        this.delegate.addListener(runnable, executor);
    }

    public boolean cancel(boolean mayInterruptIfRunning) {
        return this.delegate.cancel(mayInterruptIfRunning);
    }

    public boolean isCancelled() {
        return this.delegate.isCancelled();
    }

    public boolean isDone() {
        return this.delegate.isDone();
    }
}

