/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spring.data.firestore.mapping;

import com.google.cloud.Timestamp;
import com.google.cloud.spring.data.firestore.Document;
import com.google.cloud.spring.data.firestore.FirestoreDataException;
import com.google.cloud.spring.data.firestore.mapping.FirestorePersistentEntity;
import com.google.cloud.spring.data.firestore.mapping.FirestorePersistentProperty;
import com.google.cloud.spring.data.firestore.mapping.UpdateTime;
import java.lang.annotation.Annotation;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.model.BasicPersistentEntity;
import org.springframework.data.util.TypeInformation;
import org.springframework.util.StringUtils;

public class FirestorePersistentEntityImpl<T>
extends BasicPersistentEntity<T, FirestorePersistentProperty>
implements FirestorePersistentEntity<T> {
    private final String collectionName;
    private FirestorePersistentProperty updateTimeProperty;

    public FirestorePersistentEntityImpl(TypeInformation<T> information) {
        super(information);
        this.collectionName = FirestorePersistentEntityImpl.getEntityCollectionName(information);
    }

    @Override
    public String collectionName() {
        return this.collectionName;
    }

    @Override
    public FirestorePersistentProperty getIdPropertyOrFail() {
        FirestorePersistentProperty idProperty = (FirestorePersistentProperty)this.getIdProperty();
        if (idProperty == null) {
            throw new FirestoreDataException("An ID property was required but does not exist for the type: " + this.getType());
        }
        if (idProperty.getType() != String.class) {
            throw new FirestoreDataException("An ID property is expected to be of String type; was " + idProperty.getType());
        }
        return idProperty;
    }

    @Override
    public FirestorePersistentProperty getUpdateTimeProperty() {
        return this.updateTimeProperty;
    }

    private static <T> String getEntityCollectionName(TypeInformation<T> typeInformation) {
        Document document = (Document)AnnotationUtils.findAnnotation((Class)typeInformation.getType(), Document.class);
        String collectionName = (String)AnnotationUtils.getValue((Annotation)document, (String)"collectionName");
        if (!StringUtils.hasText((String)collectionName)) {
            return StringUtils.uncapitalize((String)typeInformation.getType().getSimpleName());
        }
        return collectionName;
    }

    public void addPersistentProperty(FirestorePersistentProperty property) {
        super.addPersistentProperty((PersistentProperty)property);
        if (property.findAnnotation(UpdateTime.class) != null) {
            if (property.getActualType() != Timestamp.class) {
                throw new FirestoreDataException("@UpdateTime annotated field should be of com.google.cloud.Timestamp type");
            }
            this.updateTimeProperty = property;
        }
    }
}

