/*
 * Decompiled with CFR 0.152.
 */
package edu.princeton.cs.algorithms;

import edu.princeton.cs.introcs.StdIn;
import edu.princeton.cs.introcs.StdOut;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class Bag<Item>
implements Iterable<Item> {
    private int N = 0;
    private Node<Item> first = null;

    public boolean isEmpty() {
        return this.first == null;
    }

    public int size() {
        return this.N;
    }

    public void add(Item item) {
        Node<Item> oldfirst = this.first;
        this.first = new Node();
        ((Node)this.first).item = item;
        ((Node)this.first).next = (Node)oldfirst;
        ++this.N;
    }

    @Override
    public Iterator<Item> iterator() {
        return new ListIterator<Item>(this.first);
    }

    public static void main(String[] args) {
        Bag<String> bag = new Bag<String>();
        while (!StdIn.isEmpty()) {
            String item = StdIn.readString();
            bag.add(item);
        }
        StdOut.println((Object)("size of bag = " + bag.size()));
        for (String s : bag) {
            StdOut.println((Object)s);
        }
    }

    private class ListIterator<Item>
    implements Iterator<Item> {
        private Node<Item> current;

        public ListIterator(Node<Item> first) {
            this.current = first;
        }

        @Override
        public boolean hasNext() {
            return this.current != null;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Item next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            Object item = ((Node)this.current).item;
            this.current = ((Node)this.current).next;
            return (Item)item;
        }
    }

    private static class Node<Item> {
        private Item item;
        private Node<Item> next;

        private Node() {
        }
    }
}

