/*
 * Decompiled with CFR 0.152.
 */
package edu.princeton.cs.algorithms;

import edu.princeton.cs.algorithms.Graph;
import edu.princeton.cs.algorithms.Queue;
import edu.princeton.cs.introcs.In;
import edu.princeton.cs.introcs.StdOut;
import java.util.Iterator;

public class CC {
    private boolean[] marked;
    private int[] id;
    private int[] size;
    private int count;

    public CC(Graph G) {
        this.marked = new boolean[G.V()];
        this.id = new int[G.V()];
        this.size = new int[G.V()];
        for (int v = 0; v < G.V(); ++v) {
            if (this.marked[v]) continue;
            this.dfs(G, v);
            ++this.count;
        }
    }

    private void dfs(Graph G, int v) {
        this.marked[v] = true;
        this.id[v] = this.count;
        int n = this.count;
        this.size[n] = this.size[n] + 1;
        for (int w : G.adj(v)) {
            if (this.marked[w]) continue;
            this.dfs(G, w);
        }
    }

    public int id(int v) {
        return this.id[v];
    }

    public int size(int v) {
        return this.size[this.id[v]];
    }

    public int count() {
        return this.count;
    }

    public boolean areConnected(int v, int w) {
        return this.id(v) == this.id(w);
    }

    public static void main(String[] args) {
        int i;
        In in = new In(args[0]);
        Graph G = new Graph(in);
        CC cc = new CC(G);
        int M = cc.count();
        StdOut.println((Object)(M + " components"));
        Queue[] components = new Queue[M];
        for (i = 0; i < M; ++i) {
            components[i] = new Queue();
        }
        for (int v = 0; v < G.V(); ++v) {
            components[cc.id(v)].enqueue(v);
        }
        for (i = 0; i < M; ++i) {
            Iterator i$ = components[i].iterator();
            while (i$.hasNext()) {
                int v = (Integer)i$.next();
                StdOut.print((Object)(v + " "));
            }
            StdOut.println();
        }
    }
}

