/*
 * Decompiled with CFR 0.152.
 */
package edu.princeton.cs.algorithms;

import edu.princeton.cs.algorithms.BreadthFirstPaths;
import edu.princeton.cs.algorithms.Graph;
import edu.princeton.cs.algorithms.SymbolGraph;
import edu.princeton.cs.introcs.StdIn;
import edu.princeton.cs.introcs.StdOut;

public class DegreesOfSeparation {
    private DegreesOfSeparation() {
    }

    public static void main(String[] args) {
        String filename = args[0];
        String delimiter = args[1];
        String source = args[2];
        SymbolGraph sg = new SymbolGraph(filename, delimiter);
        Graph G = sg.G();
        if (!sg.contains(source)) {
            StdOut.println((Object)(source + " not in database."));
            return;
        }
        int s = sg.index(source);
        BreadthFirstPaths bfs = new BreadthFirstPaths(G, s);
        while (!StdIn.isEmpty()) {
            String sink = StdIn.readLine();
            if (sg.contains(sink)) {
                int t = sg.index(sink);
                if (bfs.hasPathTo(t)) {
                    for (int v : bfs.pathTo(t)) {
                        StdOut.println((Object)("   " + sg.name(v)));
                    }
                    continue;
                }
                StdOut.println((Object)"Not connected");
                continue;
            }
            StdOut.println((Object)"   Not in database.");
        }
    }
}

