/*
 * Decompiled with CFR 0.152.
 */
package edu.princeton.cs.algorithms;

import edu.princeton.cs.algorithms.Digraph;
import edu.princeton.cs.algorithms.DirectedEdge;
import edu.princeton.cs.algorithms.EdgeWeightedDigraph;
import edu.princeton.cs.algorithms.Queue;
import edu.princeton.cs.algorithms.Stack;
import edu.princeton.cs.introcs.In;
import edu.princeton.cs.introcs.StdOut;

public class DepthFirstOrder {
    private boolean[] marked;
    private int[] pre;
    private int[] post;
    private Queue<Integer> preorder;
    private Queue<Integer> postorder;
    private int preCounter;
    private int postCounter;

    public DepthFirstOrder(Digraph G) {
        this.pre = new int[G.V()];
        this.post = new int[G.V()];
        this.postorder = new Queue();
        this.preorder = new Queue();
        this.marked = new boolean[G.V()];
        for (int v = 0; v < G.V(); ++v) {
            if (this.marked[v]) continue;
            this.dfs(G, v);
        }
    }

    public DepthFirstOrder(EdgeWeightedDigraph G) {
        this.pre = new int[G.V()];
        this.post = new int[G.V()];
        this.postorder = new Queue();
        this.preorder = new Queue();
        this.marked = new boolean[G.V()];
        for (int v = 0; v < G.V(); ++v) {
            if (this.marked[v]) continue;
            this.dfs(G, v);
        }
    }

    private void dfs(Digraph G, int v) {
        this.marked[v] = true;
        ++this.preCounter;
        this.preorder.enqueue(v);
        for (int w : G.adj(v)) {
            if (this.marked[w]) continue;
            this.dfs(G, w);
        }
        this.postorder.enqueue(v);
        ++this.postCounter;
    }

    private void dfs(EdgeWeightedDigraph G, int v) {
        this.marked[v] = true;
        ++this.preCounter;
        this.preorder.enqueue(v);
        for (DirectedEdge e : G.adj(v)) {
            int w = e.to();
            if (this.marked[w]) continue;
            this.dfs(G, w);
        }
        this.postorder.enqueue(v);
        ++this.postCounter;
    }

    public int pre(int v) {
        return this.pre[v];
    }

    public int post(int v) {
        return this.post[v];
    }

    public Iterable<Integer> post() {
        return this.postorder;
    }

    public Iterable<Integer> pre() {
        return this.preorder;
    }

    public Iterable<Integer> reversePost() {
        Stack<Integer> reverse = new Stack<Integer>();
        for (int v : this.postorder) {
            reverse.push(v);
        }
        return reverse;
    }

    private boolean check(Digraph G) {
        int r = 0;
        for (int v : this.post()) {
            if (this.post(v) != r) {
                StdOut.println((Object)"post(v) and post() inconsistent");
                return false;
            }
            ++r;
        }
        r = 0;
        for (int v : this.pre()) {
            if (this.pre(v) != r) {
                StdOut.println((Object)"pre(v) and pre() inconsistent");
                return false;
            }
            ++r;
        }
        return true;
    }

    public static void main(String[] args) {
        In in = new In(args[0]);
        Digraph G = new Digraph(in);
        DepthFirstOrder dfs = new DepthFirstOrder(G);
        StdOut.println((Object)"   v  pre post");
        StdOut.println((Object)"--------------");
        for (int v = 0; v < G.V(); ++v) {
            StdOut.printf((String)"%4d %4d %4d\n", (Object[])new Object[]{v, dfs.pre(v), dfs.post(v)});
        }
        StdOut.print((Object)"Preorder:  ");
        for (int v : dfs.pre()) {
            StdOut.print((Object)(v + " "));
        }
        StdOut.println();
        StdOut.print((Object)"Postorder: ");
        for (int v : dfs.post()) {
            StdOut.print((Object)(v + " "));
        }
        StdOut.println();
        StdOut.print((Object)"Reverse postorder: ");
        for (int v : dfs.reversePost()) {
            StdOut.print((Object)(v + " "));
        }
        StdOut.println();
    }
}

