/*
 * Decompiled with CFR 0.152.
 */
package edu.princeton.cs.algorithms;

import edu.princeton.cs.algorithms.DirectedEdge;
import edu.princeton.cs.algorithms.EdgeWeightedDigraph;
import edu.princeton.cs.algorithms.Stack;
import edu.princeton.cs.introcs.StdOut;
import edu.princeton.cs.introcs.StdRandom;

public class EdgeWeightedDirectedCycle {
    private boolean[] marked;
    private DirectedEdge[] edgeTo;
    private boolean[] onStack;
    private Stack<DirectedEdge> cycle;

    public EdgeWeightedDirectedCycle(EdgeWeightedDigraph G) {
        this.marked = new boolean[G.V()];
        this.onStack = new boolean[G.V()];
        this.edgeTo = new DirectedEdge[G.V()];
        for (int v = 0; v < G.V(); ++v) {
            if (this.marked[v]) continue;
            this.dfs(G, v);
        }
        assert (this.check(G));
    }

    private void dfs(EdgeWeightedDigraph G, int v) {
        this.onStack[v] = true;
        this.marked[v] = true;
        for (DirectedEdge e : G.adj(v)) {
            int w = e.to();
            if (this.cycle != null) {
                return;
            }
            if (!this.marked[w]) {
                this.edgeTo[w] = e;
                this.dfs(G, w);
                continue;
            }
            if (!this.onStack[w]) continue;
            this.cycle = new Stack();
            while (e.from() != w) {
                this.cycle.push(e);
                e = this.edgeTo[e.from()];
            }
            this.cycle.push(e);
        }
        this.onStack[v] = false;
    }

    public boolean hasCycle() {
        return this.cycle != null;
    }

    public Iterable<DirectedEdge> cycle() {
        return this.cycle;
    }

    private boolean check(EdgeWeightedDigraph G) {
        if (this.hasCycle()) {
            DirectedEdge first = null;
            DirectedEdge last = null;
            for (DirectedEdge e : this.cycle()) {
                if (first == null) {
                    first = e;
                }
                if (last != null && last.to() != e.from()) {
                    System.err.printf("cycle edges %s and %s not incident\n", last, e);
                    return false;
                }
                last = e;
            }
            if (last.to() != first.from()) {
                System.err.printf("cycle edges %s and %s not incident\n", last, first);
                return false;
            }
        }
        return true;
    }

    public static void main(String[] args) {
        double weight;
        int w;
        int v;
        int i;
        int V = Integer.parseInt(args[0]);
        int E = Integer.parseInt(args[1]);
        int F = Integer.parseInt(args[2]);
        EdgeWeightedDigraph G = new EdgeWeightedDigraph(V);
        int[] vertices = new int[V];
        for (i = 0; i < V; ++i) {
            vertices[i] = i;
        }
        StdRandom.shuffle((int[])vertices);
        for (i = 0; i < E; ++i) {
            while ((v = StdRandom.uniform((int)V)) >= (w = StdRandom.uniform((int)V))) {
            }
            weight = Math.random();
            G.addEdge(new DirectedEdge(v, w, weight));
        }
        for (i = 0; i < F; ++i) {
            v = (int)(Math.random() * (double)V);
            w = (int)(Math.random() * (double)V);
            weight = Math.random();
            G.addEdge(new DirectedEdge(v, w, weight));
        }
        StdOut.println((Object)G);
        EdgeWeightedDirectedCycle finder = new EdgeWeightedDirectedCycle(G);
        if (finder.hasCycle()) {
            StdOut.print((Object)"Cycle: ");
            for (DirectedEdge e : finder.cycle()) {
                StdOut.print((Object)(e + " "));
            }
            StdOut.println();
        } else {
            StdOut.println((Object)"No directed cycle");
        }
    }
}

