/*
 * Decompiled with CFR 0.152.
 */
package edu.princeton.cs.algorithms;

import edu.princeton.cs.algorithms.FlowEdge;
import edu.princeton.cs.algorithms.FlowNetwork;
import edu.princeton.cs.algorithms.Queue;
import edu.princeton.cs.introcs.StdOut;

public class FordFulkerson {
    private boolean[] marked;
    private FlowEdge[] edgeTo;
    private double value;

    public FordFulkerson(FlowNetwork G, int s, int t) {
        if (s < 0 || s >= G.V()) {
            throw new IndexOutOfBoundsException("Source s is invalid: " + s);
        }
        if (t < 0 || t >= G.V()) {
            throw new IndexOutOfBoundsException("Sink t is invalid: " + t);
        }
        if (s == t) {
            throw new IllegalArgumentException("Source equals sink");
        }
        this.value = this.excess(G, t);
        if (!this.isFeasible(G, s, t)) {
            throw new IllegalArgumentException("Initial flow is infeasible");
        }
        while (this.hasAugmentingPath(G, s, t)) {
            double bottle = Double.POSITIVE_INFINITY;
            int v = t;
            while (v != s) {
                bottle = Math.min(bottle, this.edgeTo[v].residualCapacityTo(v));
                v = this.edgeTo[v].other(v);
            }
            v = t;
            while (v != s) {
                this.edgeTo[v].addResidualFlowTo(v, bottle);
                v = this.edgeTo[v].other(v);
            }
            this.value += bottle;
        }
        assert (this.check(G, s, t));
    }

    public double value() {
        return this.value;
    }

    public boolean inCut(int v) {
        int V = this.marked.length;
        if (v < 0 || v >= V) {
            throw new IndexOutOfBoundsException("vertex " + v + " is not between 0 and " + (V - 1));
        }
        return this.marked[v];
    }

    private boolean hasAugmentingPath(FlowNetwork G, int s, int t) {
        this.edgeTo = new FlowEdge[G.V()];
        this.marked = new boolean[G.V()];
        Queue<Integer> q = new Queue<Integer>();
        q.enqueue(s);
        this.marked[s] = true;
        while (!q.isEmpty()) {
            int v = (Integer)q.dequeue();
            for (FlowEdge e : G.adj(v)) {
                int w;
                if (!(e.residualCapacityTo(w = e.other(v)) > 0.0) || this.marked[w]) continue;
                this.edgeTo[w] = e;
                this.marked[w] = true;
                q.enqueue(w);
            }
        }
        return this.marked[t];
    }

    private double excess(FlowNetwork G, int v) {
        double excess = 0.0;
        for (FlowEdge e : G.adj(v)) {
            if (v == e.from()) {
                excess -= e.flow();
                continue;
            }
            excess += e.flow();
        }
        return excess;
    }

    private boolean isFeasible(FlowNetwork G, int s, int t) {
        int v;
        double EPSILON = 1.0E-11;
        for (v = 0; v < G.V(); ++v) {
            for (FlowEdge e : G.adj(v)) {
                if (!(e.flow() < -EPSILON) && !(e.flow() > e.capacity() + EPSILON)) continue;
                System.err.println("Edge does not satisfy capacity constraints: " + e);
                return false;
            }
        }
        if (Math.abs(this.value + this.excess(G, s)) > EPSILON) {
            System.err.println("Excess at source = " + this.excess(G, s));
            System.err.println("Max flow         = " + this.value);
            return false;
        }
        if (Math.abs(this.value - this.excess(G, t)) > EPSILON) {
            System.err.println("Excess at sink   = " + this.excess(G, t));
            System.err.println("Max flow         = " + this.value);
            return false;
        }
        for (v = 0; v < G.V(); ++v) {
            if (v == s || v == t || !(Math.abs(this.excess(G, v)) > EPSILON)) continue;
            System.err.println("Net flow out of " + v + " doesn't equal zero");
            return false;
        }
        return true;
    }

    private boolean check(FlowNetwork G, int s, int t) {
        if (!this.isFeasible(G, s, t)) {
            System.err.println("Flow is infeasible");
            return false;
        }
        if (!this.inCut(s)) {
            System.err.println("source " + s + " is not on source side of min cut");
            return false;
        }
        if (this.inCut(t)) {
            System.err.println("sink " + t + " is on source side of min cut");
            return false;
        }
        double mincutValue = 0.0;
        for (int v = 0; v < G.V(); ++v) {
            for (FlowEdge e : G.adj(v)) {
                if (v != e.from() || !this.inCut(e.from()) || this.inCut(e.to())) continue;
                mincutValue += e.capacity();
            }
        }
        double EPSILON = 1.0E-11;
        if (Math.abs(mincutValue - this.value) > EPSILON) {
            System.err.println("Max flow value = " + this.value + ", min cut value = " + mincutValue);
            return false;
        }
        return true;
    }

    public static void main(String[] args) {
        int v;
        int V = Integer.parseInt(args[0]);
        int E = Integer.parseInt(args[1]);
        int s = 0;
        int t = V - 1;
        FlowNetwork G = new FlowNetwork(V, E);
        StdOut.println((Object)G);
        FordFulkerson maxflow = new FordFulkerson(G, s, t);
        StdOut.println((Object)("Max flow from " + s + " to " + t));
        for (v = 0; v < G.V(); ++v) {
            for (FlowEdge e : G.adj(v)) {
                if (v != e.from() || !(e.flow() > 0.0)) continue;
                StdOut.println((Object)("   " + e));
            }
        }
        StdOut.print((Object)"Min cut: ");
        for (v = 0; v < G.V(); ++v) {
            if (!maxflow.inCut(v)) continue;
            StdOut.print((Object)(v + " "));
        }
        StdOut.println();
        StdOut.println((Object)("Max flow value = " + maxflow.value()));
    }
}

