/*
 * Decompiled with CFR 0.152.
 */
package edu.princeton.cs.algorithms;

import edu.princeton.cs.algorithms.Digraph;
import edu.princeton.cs.algorithms.Queue;
import edu.princeton.cs.algorithms.Stack;
import edu.princeton.cs.algorithms.TransitiveClosure;
import edu.princeton.cs.introcs.In;
import edu.princeton.cs.introcs.StdOut;
import java.util.Iterator;

public class GabowSCC {
    private boolean[] marked;
    private int[] id;
    private int[] preorder;
    private int pre;
    private int count;
    private Stack<Integer> stack1;
    private Stack<Integer> stack2;

    public GabowSCC(Digraph G) {
        int v;
        this.marked = new boolean[G.V()];
        this.stack1 = new Stack();
        this.stack2 = new Stack();
        this.id = new int[G.V()];
        this.preorder = new int[G.V()];
        for (v = 0; v < G.V(); ++v) {
            this.id[v] = -1;
        }
        for (v = 0; v < G.V(); ++v) {
            if (this.marked[v]) continue;
            this.dfs(G, v);
        }
        assert (this.check(G));
    }

    private void dfs(Digraph G, int v) {
        this.marked[v] = true;
        ++this.pre;
        this.stack1.push(v);
        this.stack2.push(v);
        for (int w : G.adj(v)) {
            if (!this.marked[w]) {
                this.dfs(G, w);
                continue;
            }
            if (this.id[w] != -1) continue;
            while (this.preorder[this.stack2.peek()] > this.preorder[w]) {
                this.stack2.pop();
            }
        }
        if (this.stack2.peek() == v) {
            int w;
            this.stack2.pop();
            do {
                w = this.stack1.pop();
                this.id[w] = this.count++;
            } while (w != v);
        }
    }

    public int count() {
        return this.count;
    }

    public boolean stronglyConnected(int v, int w) {
        return this.id[v] == this.id[w];
    }

    public int id(int v) {
        return this.id[v];
    }

    private boolean check(Digraph G) {
        TransitiveClosure tc = new TransitiveClosure(G);
        for (int v = 0; v < G.V(); ++v) {
            for (int w = 0; w < G.V(); ++w) {
                if (this.stronglyConnected(v, w) == (tc.reachable(v, w) && tc.reachable(w, v))) continue;
                return false;
            }
        }
        return true;
    }

    public static void main(String[] args) {
        int i;
        In in = new In(args[0]);
        Digraph G = new Digraph(in);
        GabowSCC scc = new GabowSCC(G);
        int M = scc.count();
        StdOut.println((Object)(M + " components"));
        Queue[] components = new Queue[M];
        for (i = 0; i < M; ++i) {
            components[i] = new Queue();
        }
        for (int v = 0; v < G.V(); ++v) {
            components[scc.id(v)].enqueue(v);
        }
        for (i = 0; i < M; ++i) {
            Iterator i$ = components[i].iterator();
            while (i$.hasNext()) {
                int v = (Integer)i$.next();
                StdOut.print((Object)(v + " "));
            }
            StdOut.println();
        }
    }
}

