/*
 * Decompiled with CFR 0.152.
 */
package edu.princeton.cs.algorithms;

import edu.princeton.cs.introcs.StdIn;
import edu.princeton.cs.introcs.StdOut;
import java.util.Comparator;

public class Insertion {
    private Insertion() {
    }

    public static void sort(Comparable[] a) {
        int N = a.length;
        for (int i = 0; i < N; ++i) {
            for (int j = i; j > 0 && Insertion.less(a[j], a[j - 1]); --j) {
                Insertion.exch(a, j, j - 1);
            }
            assert (Insertion.isSorted(a, 0, i));
        }
        assert (Insertion.isSorted(a));
    }

    public static void sort(Object[] a, Comparator c) {
        int N = a.length;
        for (int i = 0; i < N; ++i) {
            for (int j = i; j > 0 && Insertion.less(c, a[j], a[j - 1]); --j) {
                Insertion.exch(a, j, j - 1);
            }
            assert (Insertion.isSorted(a, c, 0, i));
        }
        assert (Insertion.isSorted(a, c));
    }

    public static int[] indexSort(Comparable[] a) {
        int i;
        int N = a.length;
        int[] index = new int[N];
        for (i = 0; i < N; ++i) {
            index[i] = i;
        }
        for (i = 0; i < N; ++i) {
            for (int j = i; j > 0 && Insertion.less(a[index[j]], a[index[j - 1]]); --j) {
                Insertion.exch(index, j, j - 1);
            }
        }
        return index;
    }

    private static boolean less(Comparable v, Comparable w) {
        return v.compareTo(w) < 0;
    }

    private static boolean less(Comparator c, Object v, Object w) {
        return c.compare(v, w) < 0;
    }

    private static void exch(Object[] a, int i, int j) {
        Object swap = a[i];
        a[i] = a[j];
        a[j] = swap;
    }

    private static void exch(int[] a, int i, int j) {
        int swap = a[i];
        a[i] = a[j];
        a[j] = swap;
    }

    private static boolean isSorted(Comparable[] a) {
        return Insertion.isSorted(a, 0, a.length - 1);
    }

    private static boolean isSorted(Comparable[] a, int lo, int hi) {
        for (int i = lo + 1; i <= hi; ++i) {
            if (!Insertion.less(a[i], a[i - 1])) continue;
            return false;
        }
        return true;
    }

    private static boolean isSorted(Object[] a, Comparator c) {
        return Insertion.isSorted(a, c, 0, a.length - 1);
    }

    private static boolean isSorted(Object[] a, Comparator c, int lo, int hi) {
        for (int i = lo + 1; i <= hi; ++i) {
            if (!Insertion.less(c, a[i], a[i - 1])) continue;
            return false;
        }
        return true;
    }

    private static void show(Comparable[] a) {
        for (int i = 0; i < a.length; ++i) {
            StdOut.println((Object)a[i]);
        }
    }

    public static void main(String[] args) {
        String[] a = StdIn.readAllStrings();
        Insertion.sort((Comparable[])a);
        Insertion.show((Comparable[])a);
    }
}

