/*
 * Decompiled with CFR 0.152.
 */
package edu.princeton.cs.algorithms;

import edu.princeton.cs.introcs.StdIn;
import edu.princeton.cs.introcs.StdOut;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class LinkedQueue<Item>
implements Iterable<Item> {
    private int N = 0;
    private Node first = null;
    private Node last = null;

    public LinkedQueue() {
        assert (this.check());
    }

    public boolean isEmpty() {
        return this.first == null;
    }

    public int size() {
        return this.N;
    }

    public Item peek() {
        if (this.isEmpty()) {
            throw new NoSuchElementException("Queue underflow");
        }
        return (Item)this.first.item;
    }

    public void enqueue(Item item) {
        Node oldlast = this.last;
        this.last = new Node();
        this.last.item = item;
        this.last.next = null;
        if (this.isEmpty()) {
            this.first = this.last;
        } else {
            oldlast.next = this.last;
        }
        ++this.N;
        assert (this.check());
    }

    public Item dequeue() {
        if (this.isEmpty()) {
            throw new NoSuchElementException("Queue underflow");
        }
        Object item = this.first.item;
        this.first = this.first.next;
        --this.N;
        if (this.isEmpty()) {
            this.last = null;
        }
        assert (this.check());
        return (Item)item;
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        for (Item item : this) {
            s.append(item + " ");
        }
        return s.toString();
    }

    private boolean check() {
        if (this.N == 0) {
            if (this.first != null) {
                return false;
            }
            if (this.last != null) {
                return false;
            }
        } else if (this.N == 1) {
            if (this.first == null || this.last == null) {
                return false;
            }
            if (this.first != this.last) {
                return false;
            }
            if (this.first.next != null) {
                return false;
            }
        } else {
            if (this.first == this.last) {
                return false;
            }
            if (this.first.next == null) {
                return false;
            }
            if (this.last.next != null) {
                return false;
            }
            int numberOfNodes = 0;
            Node x = this.first;
            while (x != null) {
                ++numberOfNodes;
                x = x.next;
            }
            if (numberOfNodes != this.N) {
                return false;
            }
            Node lastNode = this.first;
            while (lastNode.next != null) {
                lastNode = lastNode.next;
            }
            if (this.last != lastNode) {
                return false;
            }
        }
        return true;
    }

    @Override
    public Iterator<Item> iterator() {
        return new ListIterator();
    }

    public static void main(String[] args) {
        LinkedQueue<String> q = new LinkedQueue<String>();
        while (!StdIn.isEmpty()) {
            String item = StdIn.readString();
            if (!item.equals("-")) {
                q.enqueue(item);
                continue;
            }
            if (q.isEmpty()) continue;
            StdOut.print((Object)((String)q.dequeue() + " "));
        }
        StdOut.println((Object)("(" + q.size() + " left on queue)"));
    }

    private class ListIterator
    implements Iterator<Item> {
        private Node current;

        private ListIterator() {
            this.current = LinkedQueue.this.first;
        }

        @Override
        public boolean hasNext() {
            return this.current != null;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Item next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            Object item = this.current.item;
            this.current = this.current.next;
            return item;
        }
    }

    private class Node {
        private Item item;
        private Node next;

        private Node() {
        }
    }
}

