/*
 * Decompiled with CFR 0.152.
 */
package edu.princeton.cs.algorithms;

import edu.princeton.cs.introcs.StdIn;
import edu.princeton.cs.introcs.StdOut;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class LinkedStack<Item>
implements Iterable<Item> {
    private int N = 0;
    private Node first = null;

    public LinkedStack() {
        assert (this.check());
    }

    public boolean isEmpty() {
        return this.first == null;
    }

    public int size() {
        return this.N;
    }

    public void push(Item item) {
        Node oldfirst = this.first;
        this.first = new Node();
        this.first.item = item;
        this.first.next = oldfirst;
        ++this.N;
        assert (this.check());
    }

    public Item pop() {
        if (this.isEmpty()) {
            throw new NoSuchElementException("Stack underflow");
        }
        Object item = this.first.item;
        this.first = this.first.next;
        --this.N;
        assert (this.check());
        return (Item)item;
    }

    public Item peek() {
        if (this.isEmpty()) {
            throw new NoSuchElementException("Stack underflow");
        }
        return (Item)this.first.item;
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        for (Item item : this) {
            s.append(item + " ");
        }
        return s.toString();
    }

    @Override
    public Iterator<Item> iterator() {
        return new ListIterator();
    }

    private boolean check() {
        if (this.N == 0) {
            if (this.first != null) {
                return false;
            }
        } else if (this.N == 1) {
            if (this.first == null) {
                return false;
            }
            if (this.first.next != null) {
                return false;
            }
        } else if (this.first.next == null) {
            return false;
        }
        int numberOfNodes = 0;
        Node x = this.first;
        while (x != null) {
            ++numberOfNodes;
            x = x.next;
        }
        return numberOfNodes == this.N;
    }

    public static void main(String[] args) {
        LinkedStack<String> s = new LinkedStack<String>();
        while (!StdIn.isEmpty()) {
            String item = StdIn.readString();
            if (!item.equals("-")) {
                s.push(item);
                continue;
            }
            if (s.isEmpty()) continue;
            StdOut.print((Object)((String)s.pop() + " "));
        }
        StdOut.println((Object)("(" + s.size() + " left on stack)"));
    }

    private class ListIterator
    implements Iterator<Item> {
        private Node current;

        private ListIterator() {
            this.current = LinkedStack.this.first;
        }

        @Override
        public boolean hasNext() {
            return this.current != null;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Item next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            Object item = this.current.item;
            this.current = this.current.next;
            return item;
        }
    }

    private class Node {
        private Item item;
        private Node next;

        private Node() {
        }
    }
}

