/*
 * Decompiled with CFR 0.152.
 */
package edu.princeton.cs.algorithms;

import edu.princeton.cs.introcs.StdDraw;
import java.awt.Color;

public class Particle {
    private static final double INFINITY = Double.POSITIVE_INFINITY;
    private double rx;
    private double ry;
    private double vx;
    private double vy;
    private double radius;
    private double mass;
    private Color color;
    private int count;

    public Particle(double rx, double ry, double vx, double vy, double radius, double mass, Color color) {
        this.vx = vx;
        this.vy = vy;
        this.rx = rx;
        this.ry = ry;
        this.radius = radius;
        this.mass = mass;
        this.color = color;
    }

    public Particle() {
        this.rx = Math.random();
        this.ry = Math.random();
        this.vx = 0.01 * (Math.random() - 0.5);
        this.vy = 0.01 * (Math.random() - 0.5);
        this.radius = 0.01;
        this.mass = 0.5;
        this.color = Color.BLACK;
    }

    public void move(double dt) {
        this.rx += this.vx * dt;
        this.ry += this.vy * dt;
    }

    public void draw() {
        StdDraw.setPenColor((Color)this.color);
        StdDraw.filledCircle((double)this.rx, (double)this.ry, (double)this.radius);
    }

    public int count() {
        return this.count;
    }

    public double timeToHit(Particle b) {
        Particle a = this;
        if (a == b) {
            return Double.POSITIVE_INFINITY;
        }
        double dx = b.rx - a.rx;
        double dvx = b.vx - a.vx;
        double dy = b.ry - a.ry;
        double dvy = b.vy - a.vy;
        double dvdr = dx * dvx + dy * dvy;
        if (dvdr > 0.0) {
            return Double.POSITIVE_INFINITY;
        }
        double dvdv = dvx * dvx + dvy * dvy;
        double drdr = dx * dx + dy * dy;
        double sigma = a.radius + b.radius;
        double d = dvdr * dvdr - dvdv * (drdr - sigma * sigma);
        if (d < 0.0) {
            return Double.POSITIVE_INFINITY;
        }
        return -(dvdr + Math.sqrt(d)) / dvdv;
    }

    public double timeToHitVerticalWall() {
        if (this.vx > 0.0) {
            return (1.0 - this.rx - this.radius) / this.vx;
        }
        if (this.vx < 0.0) {
            return (this.radius - this.rx) / this.vx;
        }
        return Double.POSITIVE_INFINITY;
    }

    public double timeToHitHorizontalWall() {
        if (this.vy > 0.0) {
            return (1.0 - this.ry - this.radius) / this.vy;
        }
        if (this.vy < 0.0) {
            return (this.radius - this.ry) / this.vy;
        }
        return Double.POSITIVE_INFINITY;
    }

    public void bounceOff(Particle that) {
        double dx = that.rx - this.rx;
        double dy = that.ry - this.ry;
        double dvx = that.vx - this.vx;
        double dvy = that.vy - this.vy;
        double dvdr = dx * dvx + dy * dvy;
        double dist = this.radius + that.radius;
        double F = 2.0 * this.mass * that.mass * dvdr / ((this.mass + that.mass) * dist);
        double fx = F * dx / dist;
        double fy = F * dy / dist;
        this.vx += fx / this.mass;
        this.vy += fy / this.mass;
        that.vx -= fx / that.mass;
        that.vy -= fy / that.mass;
        ++this.count;
        ++that.count;
    }

    public void bounceOffVerticalWall() {
        this.vx = -this.vx;
        ++this.count;
    }

    public void bounceOffHorizontalWall() {
        this.vy = -this.vy;
        ++this.count;
    }

    public double kineticEnergy() {
        return 0.5 * this.mass * (this.vx * this.vx + this.vy * this.vy);
    }
}

