/*
 * Decompiled with CFR 0.152.
 */
package edu.princeton.cs.algorithms;

import edu.princeton.cs.introcs.StdOut;
import java.math.BigInteger;
import java.util.Random;

public class RabinKarp {
    private String pat;
    private long patHash;
    private int M;
    private long Q;
    private int R;
    private long RM;

    public RabinKarp(int R, char[] pattern) {
        throw new UnsupportedOperationException("Operation not supported yet");
    }

    public RabinKarp(String pat) {
        this.pat = pat;
        this.R = 256;
        this.M = pat.length();
        this.Q = RabinKarp.longRandomPrime();
        this.RM = 1L;
        for (int i = 1; i <= this.M - 1; ++i) {
            this.RM = (long)this.R * this.RM % this.Q;
        }
        this.patHash = this.hash(pat, this.M);
    }

    private long hash(String key, int M) {
        long h = 0L;
        for (int j = 0; j < M; ++j) {
            h = ((long)this.R * h + (long)key.charAt(j)) % this.Q;
        }
        return h;
    }

    private boolean check(String txt, int i) {
        for (int j = 0; j < this.M; ++j) {
            if (this.pat.charAt(j) == txt.charAt(i + j)) continue;
            return false;
        }
        return true;
    }

    private boolean check(int i) {
        return true;
    }

    public int search(String txt) {
        int N = txt.length();
        if (N < this.M) {
            return N;
        }
        long txtHash = this.hash(txt, this.M);
        if (this.patHash == txtHash && this.check(txt, 0)) {
            return 0;
        }
        for (int i = this.M; i < N; ++i) {
            txtHash = (txtHash + this.Q - this.RM * (long)txt.charAt(i - this.M) % this.Q) % this.Q;
            txtHash = (txtHash * (long)this.R + (long)txt.charAt(i)) % this.Q;
            int offset = i - this.M + 1;
            if (this.patHash != txtHash || !this.check(txt, offset)) continue;
            return offset;
        }
        return N;
    }

    private static long longRandomPrime() {
        BigInteger prime = BigInteger.probablePrime(31, new Random());
        return prime.longValue();
    }

    public static void main(String[] args) {
        String pat = args[0];
        String txt = args[1];
        char[] pattern = pat.toCharArray();
        char[] text = txt.toCharArray();
        RabinKarp searcher = new RabinKarp(pat);
        int offset = searcher.search(txt);
        StdOut.println((Object)("text:    " + txt));
        StdOut.print((Object)"pattern: ");
        for (int i = 0; i < offset; ++i) {
            StdOut.print((Object)" ");
        }
        StdOut.println((Object)pat);
    }
}

