/*
 * Decompiled with CFR 0.152.
 */
package edu.princeton.cs.algorithms;

import edu.princeton.cs.introcs.StdOut;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class ResizingArrayBag<Item>
implements Iterable<Item> {
    private Item[] a = new Object[2];
    private int N = 0;

    public boolean isEmpty() {
        return this.N == 0;
    }

    public int size() {
        return this.N;
    }

    private void resize(int capacity) {
        assert (capacity >= this.N);
        Object[] temp = new Object[capacity];
        for (int i = 0; i < this.N; ++i) {
            temp[i] = this.a[i];
        }
        this.a = temp;
    }

    public void add(Item item) {
        if (this.N == this.a.length) {
            this.resize(2 * this.a.length);
        }
        this.a[this.N++] = item;
    }

    @Override
    public Iterator<Item> iterator() {
        return new ArrayIterator();
    }

    public static void main(String[] args) {
        ResizingArrayBag<String> bag = new ResizingArrayBag<String>();
        bag.add("Hello");
        bag.add("World");
        bag.add("how");
        bag.add("are");
        bag.add("you");
        for (String s : bag) {
            StdOut.println((Object)s);
        }
    }

    private class ArrayIterator
    implements Iterator<Item> {
        private int i = 0;

        private ArrayIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.i < ResizingArrayBag.this.N;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Item next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return ResizingArrayBag.this.a[this.i++];
        }
    }
}

