/*
 * Decompiled with CFR 0.152.
 */
package edu.princeton.cs.algorithms;

import edu.princeton.cs.introcs.StdIn;
import edu.princeton.cs.introcs.StdOut;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class ResizingArrayQueue<Item>
implements Iterable<Item> {
    private Item[] q = new Object[2];
    private int N = 0;
    private int first = 0;
    private int last = 0;

    public boolean isEmpty() {
        return this.N == 0;
    }

    public int size() {
        return this.N;
    }

    private void resize(int max) {
        assert (max >= this.N);
        Object[] temp = new Object[max];
        for (int i = 0; i < this.N; ++i) {
            temp[i] = this.q[(this.first + i) % this.q.length];
        }
        this.q = temp;
        this.first = 0;
        this.last = this.N;
    }

    public void enqueue(Item item) {
        if (this.N == this.q.length) {
            this.resize(2 * this.q.length);
        }
        this.q[this.last++] = item;
        if (this.last == this.q.length) {
            this.last = 0;
        }
        ++this.N;
    }

    public Item dequeue() {
        if (this.isEmpty()) {
            throw new NoSuchElementException("Queue underflow");
        }
        Item item = this.q[this.first];
        this.q[this.first] = null;
        --this.N;
        ++this.first;
        if (this.first == this.q.length) {
            this.first = 0;
        }
        if (this.N > 0 && this.N == this.q.length / 4) {
            this.resize(this.q.length / 2);
        }
        return item;
    }

    public Item peek() {
        if (this.isEmpty()) {
            throw new NoSuchElementException("Queue underflow");
        }
        return this.q[this.first];
    }

    @Override
    public Iterator<Item> iterator() {
        return new ArrayIterator();
    }

    public static void main(String[] args) {
        ResizingArrayQueue<String> q = new ResizingArrayQueue<String>();
        while (!StdIn.isEmpty()) {
            String item = StdIn.readString();
            if (!item.equals("-")) {
                q.enqueue(item);
                continue;
            }
            if (q.isEmpty()) continue;
            StdOut.print((Object)((String)q.dequeue() + " "));
        }
        StdOut.println((Object)("(" + q.size() + " left on queue)"));
    }

    private class ArrayIterator
    implements Iterator<Item> {
        private int i = 0;

        private ArrayIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.i < ResizingArrayQueue.this.N;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Item next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            Object item = ResizingArrayQueue.this.q[(this.i + ResizingArrayQueue.this.first) % ResizingArrayQueue.this.q.length];
            ++this.i;
            return item;
        }
    }
}

