/*
 * Decompiled with CFR 0.152.
 */
package edu.princeton.cs.algorithms;

import edu.princeton.cs.algorithms.SuffixArray;
import edu.princeton.cs.introcs.StdIn;
import edu.princeton.cs.introcs.StdOut;

public class SuffixArrayX {
    private static final int CUTOFF = 5;
    private final char[] text;
    private final int[] index;
    private final int N;

    public SuffixArrayX(String text) {
        this.N = text.length();
        text = text + '\u0000';
        this.text = text.toCharArray();
        this.index = new int[this.N];
        for (int i = 0; i < this.N; ++i) {
            this.index[i] = i;
        }
        this.sort(0, this.N - 1, 0);
    }

    private void sort(int lo, int hi, int d) {
        if (hi <= lo + 5) {
            this.insertion(lo, hi, d);
            return;
        }
        int lt = lo;
        int gt = hi;
        char v = this.text[this.index[lo] + d];
        int i = lo + 1;
        while (i <= gt) {
            char t = this.text[this.index[i] + d];
            if (t < v) {
                this.exch(lt++, i++);
                continue;
            }
            if (t > v) {
                this.exch(i, gt--);
                continue;
            }
            ++i;
        }
        this.sort(lo, lt - 1, d);
        if (v > '\u0000') {
            this.sort(lt, gt, d + 1);
        }
        this.sort(gt + 1, hi, d);
    }

    private void insertion(int lo, int hi, int d) {
        for (int i = lo; i <= hi; ++i) {
            for (int j = i; j > lo && this.less(this.index[j], this.index[j - 1], d); --j) {
                this.exch(j, j - 1);
            }
        }
    }

    private boolean less(int i, int j, int d) {
        if (i == j) {
            return false;
        }
        i += d;
        j += d;
        while (i < this.N && j < this.N) {
            if (this.text[i] < this.text[j]) {
                return true;
            }
            if (this.text[i] > this.text[j]) {
                return false;
            }
            ++i;
            ++j;
        }
        return i > j;
    }

    private void exch(int i, int j) {
        int swap = this.index[i];
        this.index[i] = this.index[j];
        this.index[j] = swap;
    }

    public int length() {
        return this.N;
    }

    public int index(int i) {
        if (i < 0 || i >= this.N) {
            throw new IndexOutOfBoundsException();
        }
        return this.index[i];
    }

    public int lcp(int i) {
        if (i < 1 || i >= this.N) {
            throw new IndexOutOfBoundsException();
        }
        return this.lcp(this.index[i], this.index[i - 1]);
    }

    private int lcp(int i, int j) {
        int length = 0;
        while (i < this.N && j < this.N) {
            if (this.text[i] != this.text[j]) {
                return length;
            }
            ++i;
            ++j;
            ++length;
        }
        return length;
    }

    public String select(int i) {
        if (i < 0 || i >= this.N) {
            throw new IndexOutOfBoundsException();
        }
        return new String(this.text, this.index[i], this.N - this.index[i]);
    }

    public int rank(String query) {
        int lo = 0;
        int hi = this.N - 1;
        while (lo <= hi) {
            int mid = lo + (hi - lo) / 2;
            int cmp = this.compare(query, this.index[mid]);
            if (cmp < 0) {
                hi = mid - 1;
                continue;
            }
            if (cmp > 0) {
                lo = mid + 1;
                continue;
            }
            return mid;
        }
        return lo;
    }

    private int compare(String query, int i) {
        int j;
        int M = query.length();
        for (j = 0; i < this.N && j < M; ++i, ++j) {
            if (query.charAt(j) == this.text[i]) continue;
            return query.charAt(j) - this.text[i];
        }
        if (i < this.N) {
            return -1;
        }
        if (j < M) {
            return 1;
        }
        return 0;
    }

    public static void main(String[] args) {
        int i;
        String s = StdIn.readAll().replaceAll("\n", " ").trim();
        SuffixArrayX suffix = new SuffixArrayX(s);
        SuffixArray suffixReference = new SuffixArray(s);
        boolean check = true;
        for (i = 0; check && i < s.length(); ++i) {
            if (suffixReference.index(i) == suffix.index(i)) continue;
            StdOut.println((Object)("suffixReference(" + i + ") = " + suffixReference.index(i)));
            StdOut.println((Object)("suffix(" + i + ") = " + suffix.index(i)));
            String ith = "\"" + s.substring(suffix.index(i), Math.min(suffix.index(i) + 50, s.length())) + "\"";
            String jth = "\"" + s.substring(suffixReference.index(i), Math.min(suffixReference.index(i) + 50, s.length())) + "\"";
            StdOut.println((Object)ith);
            StdOut.println((Object)jth);
            check = false;
        }
        StdOut.println((Object)"  i ind lcp rnk  select");
        StdOut.println((Object)"---------------------------");
        for (i = 0; i < s.length(); ++i) {
            int index = suffix.index(i);
            String ith = "\"" + s.substring(index, Math.min(index + 50, s.length())) + "\"";
            int rank = suffix.rank(s.substring(index));
            assert (s.substring(index).equals(suffix.select(i)));
            if (i == 0) {
                StdOut.printf((String)"%3d %3d %3s %3d  %s\n", (Object[])new Object[]{i, index, "-", rank, ith});
                continue;
            }
            int lcp = suffix.lcp(i);
            StdOut.printf((String)"%3d %3d %3d %3d  %s\n", (Object[])new Object[]{i, index, lcp, rank, ith});
        }
    }
}

