/*
 * Decompiled with CFR 0.152.
 */
package edu.princeton.cs.algorithms;

import edu.princeton.cs.algorithms.Digraph;
import edu.princeton.cs.algorithms.ST;
import edu.princeton.cs.introcs.In;
import edu.princeton.cs.introcs.StdIn;
import edu.princeton.cs.introcs.StdOut;
import java.util.Iterator;

public class SymbolDigraph {
    private ST<String, Integer> st = new ST();
    private String[] keys;
    private Digraph G;

    public SymbolDigraph(String filename, String delimiter) {
        String[] a;
        In in = new In(filename);
        while (in.hasNextLine()) {
            a = in.readLine().split(delimiter);
            for (int i = 0; i < a.length; ++i) {
                if (this.st.contains(a[i])) continue;
                this.st.put(a[i], this.st.size());
            }
        }
        this.keys = new String[this.st.size()];
        Iterator<String> i$ = this.st.keys().iterator();
        while (i$.hasNext()) {
            String name;
            this.keys[this.st.get((String)name).intValue()] = name = i$.next();
        }
        this.G = new Digraph(this.st.size());
        in = new In(filename);
        while (in.hasNextLine()) {
            a = in.readLine().split(delimiter);
            int v = this.st.get(a[0]);
            for (int i = 1; i < a.length; ++i) {
                int w = this.st.get(a[i]);
                this.G.addEdge(v, w);
            }
        }
    }

    public boolean contains(String s) {
        return this.st.contains(s);
    }

    public int index(String s) {
        return this.st.get(s);
    }

    public String name(int v) {
        return this.keys[v];
    }

    public Digraph G() {
        return this.G;
    }

    public static void main(String[] args) {
        String filename = args[0];
        String delimiter = args[1];
        SymbolDigraph sg = new SymbolDigraph(filename, delimiter);
        Digraph G = sg.G();
        while (!StdIn.isEmpty()) {
            String t = StdIn.readLine();
            for (int v : G.adj(sg.index(t))) {
                StdOut.println((Object)("   " + sg.name(v)));
            }
        }
    }
}

