/*
 * Decompiled with CFR 0.152.
 */
package edu.princeton.cs.algorithms;

import edu.princeton.cs.algorithms.Digraph;
import edu.princeton.cs.algorithms.Queue;
import edu.princeton.cs.algorithms.Stack;
import edu.princeton.cs.algorithms.TransitiveClosure;
import edu.princeton.cs.introcs.In;
import edu.princeton.cs.introcs.StdOut;
import java.util.Iterator;

public class TarjanSCC {
    private boolean[] marked;
    private int[] id;
    private int[] low;
    private int pre;
    private int count;
    private Stack<Integer> stack;

    public TarjanSCC(Digraph G) {
        this.marked = new boolean[G.V()];
        this.stack = new Stack();
        this.id = new int[G.V()];
        this.low = new int[G.V()];
        for (int v = 0; v < G.V(); ++v) {
            if (this.marked[v]) continue;
            this.dfs(G, v);
        }
        assert (this.check(G));
    }

    private void dfs(Digraph G, int v) {
        int w;
        this.marked[v] = true;
        ++this.pre;
        int min = this.low[v];
        this.stack.push(v);
        for (int w2 : G.adj(v)) {
            if (!this.marked[w2]) {
                this.dfs(G, w2);
            }
            if (this.low[w2] >= min) continue;
            min = this.low[w2];
        }
        if (min < this.low[v]) {
            this.low[v] = min;
            return;
        }
        do {
            w = this.stack.pop();
            this.id[w] = this.count++;
            this.low[w] = G.V();
        } while (w != v);
    }

    public int count() {
        return this.count;
    }

    public boolean stronglyConnected(int v, int w) {
        return this.id[v] == this.id[w];
    }

    public int id(int v) {
        return this.id[v];
    }

    private boolean check(Digraph G) {
        TransitiveClosure tc = new TransitiveClosure(G);
        for (int v = 0; v < G.V(); ++v) {
            for (int w = 0; w < G.V(); ++w) {
                if (this.stronglyConnected(v, w) == (tc.reachable(v, w) && tc.reachable(w, v))) continue;
                return false;
            }
        }
        return true;
    }

    public static void main(String[] args) {
        int i;
        In in = new In(args[0]);
        Digraph G = new Digraph(in);
        TarjanSCC scc = new TarjanSCC(G);
        int M = scc.count();
        StdOut.println((Object)(M + " components"));
        Queue[] components = new Queue[M];
        for (i = 0; i < M; ++i) {
            components[i] = new Queue();
        }
        for (int v = 0; v < G.V(); ++v) {
            components[scc.id(v)].enqueue(v);
        }
        for (i = 0; i < M; ++i) {
            Iterator i$ = components[i].iterator();
            while (i$.hasNext()) {
                int v = (Integer)i$.next();
                StdOut.print((Object)(v + " "));
            }
            StdOut.println();
        }
    }
}

