/*
 * Decompiled with CFR 0.152.
 */
package edu.princeton.cs.algorithms;

import edu.princeton.cs.algorithms.Digraph;
import edu.princeton.cs.algorithms.DirectedDFS;
import edu.princeton.cs.introcs.In;
import edu.princeton.cs.introcs.StdOut;

public class TransitiveClosure {
    private DirectedDFS[] tc;

    public TransitiveClosure(Digraph G) {
        this.tc = new DirectedDFS[G.V()];
        for (int v = 0; v < G.V(); ++v) {
            this.tc[v] = new DirectedDFS(G, v);
        }
    }

    public boolean reachable(int v, int w) {
        return this.tc[v].marked(w);
    }

    public static void main(String[] args) {
        int v;
        In in = new In(args[0]);
        Digraph G = new Digraph(in);
        TransitiveClosure tc = new TransitiveClosure(G);
        StdOut.print((Object)"     ");
        for (v = 0; v < G.V(); ++v) {
            StdOut.printf((String)"%3d", (Object[])new Object[]{v});
        }
        StdOut.println();
        StdOut.println((Object)"--------------------------------------------");
        for (v = 0; v < G.V(); ++v) {
            StdOut.printf((String)"%3d: ", (Object[])new Object[]{v});
            for (int w = 0; w < G.V(); ++w) {
                if (tc.reachable(v, w)) {
                    StdOut.printf((String)"  T", (Object[])new Object[0]);
                    continue;
                }
                StdOut.printf((String)"   ", (Object[])new Object[0]);
            }
            StdOut.println();
        }
    }
}

