/*
 * Decompiled with CFR 0.152.
 */
package edu.princeton.cs.algorithms;

import edu.princeton.cs.introcs.StdIn;
import edu.princeton.cs.introcs.StdOut;

public class UF {
    private int[] id;
    private byte[] rank;
    private int count;

    public UF(int N) {
        if (N < 0) {
            throw new IllegalArgumentException();
        }
        this.count = N;
        this.id = new int[N];
        this.rank = new byte[N];
        for (int i = 0; i < N; ++i) {
            this.id[i] = i;
            this.rank[i] = 0;
        }
    }

    public int find(int p) {
        if (p < 0 || p >= this.id.length) {
            throw new IndexOutOfBoundsException();
        }
        while (p != this.id[p]) {
            this.id[p] = this.id[this.id[p]];
            p = this.id[p];
        }
        return p;
    }

    public int count() {
        return this.count;
    }

    public boolean connected(int p, int q) {
        return this.find(p) == this.find(q);
    }

    public void union(int p, int q) {
        int j;
        int i = this.find(p);
        if (i == (j = this.find(q))) {
            return;
        }
        if (this.rank[i] < this.rank[j]) {
            this.id[i] = j;
        } else if (this.rank[i] > this.rank[j]) {
            this.id[j] = i;
        } else {
            this.id[j] = i;
            int n = i;
            this.rank[n] = (byte)(this.rank[n] + 1);
        }
        --this.count;
    }

    public static void main(String[] args) {
        int N = StdIn.readInt();
        UF uf = new UF(N);
        while (!StdIn.isEmpty()) {
            int q;
            int p = StdIn.readInt();
            if (uf.connected(p, q = StdIn.readInt())) continue;
            uf.union(p, q);
            StdOut.println((Object)(p + " " + q));
        }
        StdOut.println((Object)(uf.count() + " components"));
    }
}

