/*
 * Decompiled with CFR 0.152.
 */
package edu.princeton.cs.algorithms;

import edu.princeton.cs.introcs.StdOut;

public class Vector {
    private int N;
    private double[] data;

    public Vector(int d) {
        this.N = d;
        this.data = new double[this.N];
    }

    public Vector(double ... a) {
        this.N = a.length;
        this.data = new double[this.N];
        for (int i = 0; i < this.N; ++i) {
            this.data[i] = a[i];
        }
    }

    public int length() {
        return this.N;
    }

    public double dot(Vector that) {
        if (this.N != that.N) {
            throw new IllegalArgumentException("Dimensions don't agree");
        }
        double sum = 0.0;
        for (int i = 0; i < this.N; ++i) {
            sum += this.data[i] * that.data[i];
        }
        return sum;
    }

    public double magnitude() {
        return Math.sqrt(this.dot(this));
    }

    public double distanceTo(Vector that) {
        if (this.N != that.N) {
            throw new IllegalArgumentException("Dimensions don't agree");
        }
        return this.minus(that).magnitude();
    }

    public Vector plus(Vector that) {
        if (this.N != that.N) {
            throw new IllegalArgumentException("Dimensions don't agree");
        }
        Vector c = new Vector(this.N);
        for (int i = 0; i < this.N; ++i) {
            c.data[i] = this.data[i] + that.data[i];
        }
        return c;
    }

    public Vector minus(Vector that) {
        if (this.N != that.N) {
            throw new IllegalArgumentException("Dimensions don't agree");
        }
        Vector c = new Vector(this.N);
        for (int i = 0; i < this.N; ++i) {
            c.data[i] = this.data[i] - that.data[i];
        }
        return c;
    }

    public double cartesian(int i) {
        return this.data[i];
    }

    public Vector times(double factor) {
        Vector c = new Vector(this.N);
        for (int i = 0; i < this.N; ++i) {
            c.data[i] = factor * this.data[i];
        }
        return c;
    }

    public Vector direction() {
        if (this.magnitude() == 0.0) {
            throw new ArithmeticException("Zero-vector has no direction");
        }
        return this.times(1.0 / this.magnitude());
    }

    public String toString() {
        String s = "";
        for (int i = 0; i < this.N; ++i) {
            s = s + this.data[i] + " ";
        }
        return s;
    }

    public static void main(String[] args) {
        double[] xdata = new double[]{1.0, 2.0, 3.0, 4.0};
        double[] ydata = new double[]{5.0, 2.0, 4.0, 1.0};
        Vector x = new Vector(xdata);
        Vector y = new Vector(ydata);
        StdOut.println((Object)("   x       = " + x));
        StdOut.println((Object)("   y       = " + y));
        Vector z = x.plus(y);
        StdOut.println((Object)("   z       = " + z));
        z = z.times(10.0);
        StdOut.println((Object)(" 10z       = " + z));
        StdOut.println((Object)("  |x|      = " + x.magnitude()));
        StdOut.println((Object)(" <x, y>    = " + x.dot(y)));
        StdOut.println((Object)("dist(x, y) = " + x.distanceTo(y)));
        StdOut.println((Object)("dir(x)     = " + x.direction()));
    }
}

