/*
 * Decompiled with CFR 0.152.
 */
package edu.princeton.cs.introcs;

import edu.princeton.cs.introcs.StdOut;
import java.util.Random;

public final class StdRandom {
    private static Random random;
    private static long seed;

    private StdRandom() {
    }

    public static void setSeed(long s) {
        seed = s;
        random = new Random(seed);
    }

    public static long getSeed() {
        return seed;
    }

    public static double uniform() {
        return random.nextDouble();
    }

    public static int uniform(int N) {
        if (N <= 0) {
            throw new IllegalArgumentException("Parameter N must be positive");
        }
        return random.nextInt(N);
    }

    public static double random() {
        return StdRandom.uniform();
    }

    public static int uniform(int a, int b) {
        if (b <= a) {
            throw new IllegalArgumentException("Invalid range");
        }
        if ((long)b - (long)a >= Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Invalid range");
        }
        return a + StdRandom.uniform(b - a);
    }

    public static double uniform(double a, double b) {
        if (b <= a) {
            throw new IllegalArgumentException("Invalid range");
        }
        return a + StdRandom.uniform() * (b - a);
    }

    public static boolean bernoulli(double p) {
        if (p < 0.0 || p > 1.0) {
            throw new IllegalArgumentException("Probability must be between 0.0 and 1.0");
        }
        return StdRandom.uniform() < p;
    }

    public static boolean bernoulli() {
        return StdRandom.bernoulli(0.5);
    }

    public static double gaussian() {
        double y;
        double x;
        double r;
        while ((r = (x = StdRandom.uniform(-1.0, 1.0)) * x + (y = StdRandom.uniform(-1.0, 1.0)) * y) >= 1.0 || r == 0.0) {
        }
        return x * Math.sqrt(-2.0 * Math.log(r) / r);
    }

    public static double gaussian(double mean, double stddev) {
        return mean + stddev * StdRandom.gaussian();
    }

    public static int geometric(double p) {
        if (p < 0.0 || p > 1.0) {
            throw new IllegalArgumentException("Probability must be between 0.0 and 1.0");
        }
        return (int)Math.ceil(Math.log(StdRandom.uniform()) / Math.log(1.0 - p));
    }

    public static int poisson(double lambda) {
        if (lambda <= 0.0) {
            throw new IllegalArgumentException("Parameter lambda must be positive");
        }
        int k = 0;
        double p = 1.0;
        double L = Math.exp(-lambda);
        do {
            ++k;
        } while ((p *= StdRandom.uniform()) >= L);
        return k - 1;
    }

    public static double pareto(double alpha) {
        if (alpha <= 0.0) {
            throw new IllegalArgumentException("Shape parameter alpha must be positive");
        }
        return Math.pow(1.0 - StdRandom.uniform(), -1.0 / alpha) - 1.0;
    }

    public static double cauchy() {
        return Math.tan(Math.PI * (StdRandom.uniform() - 0.5));
    }

    public static int discrete(double[] a) {
        double EPSILON = 1.0E-14;
        double sum = 0.0;
        for (int i = 0; i < a.length; ++i) {
            if (a[i] < 0.0) {
                throw new IllegalArgumentException("array entry " + i + " is negative: " + a[i]);
            }
            sum += a[i];
        }
        if (sum > 1.0 + EPSILON || sum < 1.0 - EPSILON) {
            throw new IllegalArgumentException("sum of array entries not equal to one: " + sum);
        }
        block1: while (true) {
            double r = StdRandom.uniform();
            sum = 0.0;
            int i = 0;
            while (true) {
                if (i >= a.length) continue block1;
                if ((sum += a[i]) > r) {
                    return i;
                }
                ++i;
            }
            break;
        }
    }

    public static double exp(double lambda) {
        if (lambda <= 0.0) {
            throw new IllegalArgumentException("Rate lambda must be positive");
        }
        return -Math.log(1.0 - StdRandom.uniform()) / lambda;
    }

    public static void shuffle(Object[] a) {
        int N = a.length;
        for (int i = 0; i < N; ++i) {
            int r = i + StdRandom.uniform(N - i);
            Object temp = a[i];
            a[i] = a[r];
            a[r] = temp;
        }
    }

    public static void shuffle(double[] a) {
        int N = a.length;
        for (int i = 0; i < N; ++i) {
            int r = i + StdRandom.uniform(N - i);
            double temp = a[i];
            a[i] = a[r];
            a[r] = temp;
        }
    }

    public static void shuffle(int[] a) {
        int N = a.length;
        for (int i = 0; i < N; ++i) {
            int r = i + StdRandom.uniform(N - i);
            int temp = a[i];
            a[i] = a[r];
            a[r] = temp;
        }
    }

    public static void shuffle(Object[] a, int lo, int hi) {
        if (lo < 0 || lo > hi || hi >= a.length) {
            throw new IndexOutOfBoundsException("Illegal subarray range");
        }
        for (int i = lo; i <= hi; ++i) {
            int r = i + StdRandom.uniform(hi - i + 1);
            Object temp = a[i];
            a[i] = a[r];
            a[r] = temp;
        }
    }

    public static void shuffle(double[] a, int lo, int hi) {
        if (lo < 0 || lo > hi || hi >= a.length) {
            throw new IndexOutOfBoundsException("Illegal subarray range");
        }
        for (int i = lo; i <= hi; ++i) {
            int r = i + StdRandom.uniform(hi - i + 1);
            double temp = a[i];
            a[i] = a[r];
            a[r] = temp;
        }
    }

    public static void shuffle(int[] a, int lo, int hi) {
        if (lo < 0 || lo > hi || hi >= a.length) {
            throw new IndexOutOfBoundsException("Illegal subarray range");
        }
        for (int i = lo; i <= hi; ++i) {
            int r = i + StdRandom.uniform(hi - i + 1);
            int temp = a[i];
            a[i] = a[r];
            a[r] = temp;
        }
    }

    public static void main(String[] args) {
        String[] a;
        int N = Integer.parseInt(args[0]);
        if (args.length == 2) {
            StdRandom.setSeed(Long.parseLong(args[1]));
        }
        double[] t = new double[]{0.5, 0.3, 0.1, 0.1};
        StdOut.println("seed = " + StdRandom.getSeed());
        for (int i = 0; i < N; ++i) {
            StdOut.printf("%2d ", StdRandom.uniform(100));
            StdOut.printf("%8.5f ", StdRandom.uniform(10.0, 99.0));
            StdOut.printf("%5b ", StdRandom.bernoulli(0.5));
            StdOut.printf("%7.5f ", StdRandom.gaussian(9.0, 0.2));
            StdOut.printf("%2d ", StdRandom.discrete(t));
            StdOut.println();
        }
        for (String s : a = "A B C D E F G".split(" ")) {
            StdOut.print(s + " ");
        }
        StdOut.println();
    }

    static {
        seed = System.currentTimeMillis();
        random = new Random(seed);
    }
}

