/*
 * Decompiled with CFR 0.152.
 */
package org.h2.mvstore;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.h2.compress.CompressDeflate;
import org.h2.compress.CompressLZF;
import org.h2.compress.Compressor;
import org.h2.mvstore.Chunk;
import org.h2.mvstore.Cursor;
import org.h2.mvstore.DataUtils;
import org.h2.mvstore.FileStore;
import org.h2.mvstore.MVMap;
import org.h2.mvstore.Page;
import org.h2.mvstore.WriteBuffer;
import org.h2.mvstore.cache.CacheLongKeyLIRS;
import org.h2.mvstore.type.StringDataType;
import org.h2.util.MathUtils;
import org.h2.util.New;

public class MVStore {
    public static final boolean ASSERT = false;
    static final int BLOCK_SIZE = 4096;
    private static final int FORMAT_WRITE = 1;
    private static final int FORMAT_READ = 1;
    private static final int MARKED_FREE = 10000000;
    volatile BackgroundWriterThread backgroundWriterThread;
    private volatile boolean reuseSpace = true;
    private boolean closed;
    private FileStore fileStore;
    private boolean fileStoreIsProvided;
    private final int pageSplitSize;
    private CacheLongKeyLIRS<Page> cache;
    private CacheLongKeyLIRS<Page.PageChildren> cacheChunkRef;
    private Chunk lastChunk;
    private final ConcurrentHashMap<Integer, Chunk> chunks = new ConcurrentHashMap();
    private final ConcurrentHashMap<Long, HashMap<Integer, Chunk>> freedPageSpace = new ConcurrentHashMap();
    private MVMap<String, String> meta;
    private final ConcurrentHashMap<Integer, MVMap<?, ?>> maps = new ConcurrentHashMap();
    private HashMap<String, Object> storeHeader = New.hashMap();
    private WriteBuffer writeBuffer;
    private int lastMapId;
    private int versionsToKeep = 5;
    private final int compressionLevel;
    private Compressor compressorFast;
    private Compressor compressorHigh;
    private final Thread.UncaughtExceptionHandler backgroundExceptionHandler;
    private long currentVersion;
    private long lastStoredVersion;
    private int unsavedMemory;
    private int autoCommitMemory;
    private boolean saveNeeded;
    private long creationTime;
    private int retentionTime;
    private long lastCommitTime;
    private Chunk retainChunk;
    private volatile long currentStoreVersion = -1L;
    private Thread currentStoreThread;
    private volatile boolean metaChanged;
    private int autoCommitDelay;
    private int autoCompactFillRate;
    private long autoCompactLastFileOpCount;
    private Object compactSync = new Object();
    private IllegalStateException panicException;
    private long lastTimeAbsolute;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    MVStore(HashMap<String, Object> hashMap) {
        int n;
        Object object = hashMap.get("compress");
        this.compressionLevel = object == null ? 0 : (Integer)object;
        String string = (String)hashMap.get("fileName");
        object = hashMap.get("pageSplitSize");
        this.pageSplitSize = object == null ? (string == null ? 4096 : 16384) : (Integer)object;
        object = hashMap.get("backgroundExceptionHandler");
        this.backgroundExceptionHandler = (Thread.UncaughtExceptionHandler)object;
        this.meta = new MVMap(StringDataType.INSTANCE, StringDataType.INSTANCE);
        HashMap<String, Object> hashMap2 = New.hashMap();
        hashMap2.put("id", 0);
        hashMap2.put("createVersion", this.currentVersion);
        this.meta.init(this, hashMap2);
        this.fileStore = (FileStore)hashMap.get("fileStore");
        if (string == null && this.fileStore == null) {
            this.cache = null;
            this.cacheChunkRef = null;
            return;
        }
        if (this.fileStore == null) {
            this.fileStoreIsProvided = false;
            this.fileStore = new FileStore();
        } else {
            this.fileStoreIsProvided = true;
        }
        this.retentionTime = this.fileStore.getDefaultRetentionTime();
        boolean bl = hashMap.containsKey("readOnly");
        object = hashMap.get("cacheSize");
        int n2 = n = object == null ? 16 : (Integer)object;
        if (n > 0) {
            CacheLongKeyLIRS.Config config = new CacheLongKeyLIRS.Config();
            config.maxMemory = (long)n * 1024L * 1024L;
            this.cache = new CacheLongKeyLIRS(config);
            config.maxMemory /= 4L;
            this.cacheChunkRef = new CacheLongKeyLIRS(config);
        }
        int n3 = (object = hashMap.get("autoCommitBufferSize")) == null ? 1024 : (Integer)object;
        this.autoCommitMemory = n3 * 1024 * 19;
        object = hashMap.get("autoCompactFillRate");
        this.autoCompactFillRate = object == null ? 50 : (Integer)object;
        char[] cArray = (char[])hashMap.get("encryptionKey");
        try {
            if (!this.fileStoreIsProvided) {
                this.fileStore.open(string, bl, cArray);
            }
            if (this.fileStore.size() == 0L) {
                this.lastCommitTime = this.creationTime = this.getTimeAbsolute();
                this.storeHeader.put("H", 2);
                this.storeHeader.put("blockSize", 4096);
                this.storeHeader.put("format", 1);
                this.storeHeader.put("created", this.creationTime);
                this.writeStoreHeader();
            } else {
                this.readStoreHeader();
            }
        }
        catch (IllegalStateException illegalStateException) {
            this.panic(illegalStateException);
        }
        finally {
            if (cArray != null) {
                Arrays.fill(cArray, '\u0000');
            }
        }
        this.lastCommitTime = this.getTimeSinceCreation();
        object = hashMap.get("autoCommitDelay");
        int n4 = object == null ? 1000 : (Integer)object;
        this.setAutoCommitDelay(n4);
    }

    private void panic(IllegalStateException illegalStateException) {
        if (this.backgroundExceptionHandler != null) {
            this.backgroundExceptionHandler.uncaughtException(null, illegalStateException);
        }
        this.panicException = illegalStateException;
        this.closeImmediately();
        throw illegalStateException;
    }

    public static MVStore open(String string) {
        HashMap<String, Object> hashMap = New.hashMap();
        hashMap.put("fileName", string);
        return new MVStore(hashMap);
    }

    <T extends MVMap<?, ?>> T openMapVersion(long l, int n, MVMap<?, ?> mVMap) {
        MVMap<String, String> mVMap2 = this.getMetaMap(l);
        long l2 = MVStore.getRootPos(mVMap2, n);
        MVMap<?, ?> mVMap3 = mVMap.openReadOnly();
        mVMap3.setRootPos(l2, l);
        return (T)mVMap3;
    }

    public <K, V> MVMap<K, V> openMap(String string) {
        return this.openMap(string, new MVMap.Builder());
    }

    public synchronized <M extends MVMap<K, V>, K, V> M openMap(String string, MVMap.MapBuilder<M, K, V> mapBuilder) {
        long l;
        M m;
        int n;
        this.checkOpen();
        String string2 = this.meta.get("name." + string);
        if (string2 != null) {
            n = DataUtils.parseHexInt(string2);
            MVMap<?, ?> mVMap = this.maps.get(n);
            if (mVMap != null) {
                return (M)mVMap;
            }
            m = mapBuilder.create();
            String string3 = this.meta.get(MVMap.getMapKey(n));
            HashMap<String, Object> hashMap = New.hashMap();
            hashMap.putAll(DataUtils.parseMap(string3));
            hashMap.put("id", n);
            ((MVMap)m).init(this, hashMap);
            l = MVStore.getRootPos(this.meta, n);
        } else {
            HashMap<String, Object> hashMap = New.hashMap();
            n = ++this.lastMapId;
            hashMap.put("id", n);
            hashMap.put("createVersion", this.currentVersion);
            m = mapBuilder.create();
            ((MVMap)m).init(this, hashMap);
            this.markMetaChanged();
            string2 = Integer.toHexString(n);
            this.meta.put(MVMap.getMapKey(n), ((MVMap)m).asString(string));
            this.meta.put("name." + string, string2);
            l = 0L;
        }
        ((MVMap)m).setRootPos(l, -1L);
        this.maps.put(n, (MVMap<?, ?>)m);
        return m;
    }

    public synchronized Set<String> getMapNames() {
        String string;
        HashSet<String> hashSet = New.hashSet();
        this.checkOpen();
        Iterator<String> iterator = this.meta.keyIterator("name.");
        while (iterator.hasNext() && (string = iterator.next()).startsWith("name.")) {
            hashSet.add(string.substring("name.".length()));
        }
        return hashSet;
    }

    public MVMap<String, String> getMetaMap() {
        this.checkOpen();
        return this.meta;
    }

    private MVMap<String, String> getMetaMap(long l) {
        Chunk chunk = this.getChunkForVersion(l);
        DataUtils.checkArgument(chunk != null, "Unknown version {0}", l);
        chunk = this.readChunkHeader(chunk.block);
        MVMap<String, String> mVMap = this.meta.openReadOnly();
        mVMap.setRootPos(chunk.metaRootPos, l);
        return mVMap;
    }

    private Chunk getChunkForVersion(long l) {
        Chunk chunk = null;
        for (Chunk chunk2 : this.chunks.values()) {
            if (chunk2.version > l || chunk != null && chunk2.id <= chunk.id) continue;
            chunk = chunk2;
        }
        return chunk;
    }

    public boolean hasMap(String string) {
        return this.meta.containsKey("name." + string);
    }

    private void markMetaChanged() {
        this.metaChanged = true;
    }

    private synchronized void readStoreHeader() {
        Object object;
        int n;
        Object object2 = null;
        boolean bl = false;
        ByteBuffer byteBuffer = this.fileStore.readFully(0L, 8192);
        byte[] byArray = new byte[4096];
        for (int i = 0; i <= 4096; i += 4096) {
            byteBuffer.get(byArray);
            try {
                String string = new String(byArray, 0, 4096, DataUtils.LATIN).trim();
                HashMap<String, String> hashMap = DataUtils.parseMap(string);
                int n2 = DataUtils.readHexInt(hashMap, "blockSize", 4096);
                if (n2 != 4096) {
                    throw DataUtils.newIllegalStateException(5, "Block size {0} is currently not supported", n2);
                }
                n = DataUtils.readHexInt(hashMap, "fletcher", 0);
                hashMap.remove("fletcher");
                string = string.substring(0, string.lastIndexOf("fletcher") - 1);
                object = string.getBytes(DataUtils.LATIN);
                int n3 = DataUtils.getFletcher32(object, ((byte[])object).length);
                if (n != n3) continue;
                long l = DataUtils.readHexLong(hashMap, "version", 0L);
                if (object2 != null && l <= object2.version) continue;
                bl = true;
                this.storeHeader.putAll(hashMap);
                this.creationTime = DataUtils.readHexLong(hashMap, "created", 0L);
                int n4 = DataUtils.readHexInt(hashMap, "chunk", 0);
                long l2 = DataUtils.readHexLong(hashMap, "block", 0L);
                Chunk chunk = this.readChunkHeaderAndFooter(l2);
                if (chunk == null || chunk.id != n4) continue;
                object2 = chunk;
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (!bl) {
            throw DataUtils.newIllegalStateException(6, "Store header is corrupt: {0}", this.fileStore);
        }
        long l = DataUtils.readHexLong(this.storeHeader, "format", 1L);
        if (l > 1L && !this.fileStore.isReadOnly()) {
            throw DataUtils.newIllegalStateException(5, "The write format {0} is larger than the supported format {1}, and the file was not opened in read-only mode", l, 1);
        }
        if ((l = DataUtils.readHexLong(this.storeHeader, "formatRead", l)) > 1L) {
            throw DataUtils.newIllegalStateException(5, "The read format {0} is larger than the supported format {1}", l, 1);
        }
        this.lastStoredVersion = -1L;
        this.chunks.clear();
        long l3 = System.currentTimeMillis();
        n = 1970 + (int)(l3 / 31557600000L);
        if (n < 2014) {
            this.creationTime = l3 - (long)this.fileStore.getDefaultRetentionTime();
        } else if (l3 < this.creationTime) {
            this.creationTime = l3;
            this.storeHeader.put("created", this.creationTime);
        }
        object = this.readChunkFooter(this.fileStore.size());
        if (object != null && (object = (Object)this.readChunkHeaderAndFooter(object.block)) != null && (object2 == null || object.version > object2.version)) {
            object2 = object;
        }
        if (object2 == null) {
            return;
        }
        while (object2.next != 0L && object2.next < this.fileStore.size() / 4096L && (object = (Object)this.readChunkHeaderAndFooter(object2.next)) != null && object.id > object2.id) {
            object2 = object;
        }
        this.setLastChunk((Chunk)object2);
        this.loadChunkMeta();
        this.verifyLastChunks();
        for (Chunk chunk : this.chunks.values()) {
            if (chunk.pageCountLive == 0) {
                this.registerFreePage(this.currentVersion, chunk.id, 0L, 0);
            }
            long l4 = chunk.block * 4096L;
            int n5 = chunk.len * 4096;
            this.fileStore.markUsed(l4, n5);
        }
    }

    private void loadChunkMeta() {
        String string;
        Iterator<String> iterator = this.meta.keyIterator("chunk.");
        while (iterator.hasNext() && (string = iterator.next()).startsWith("chunk.")) {
            string = this.meta.get(string);
            Chunk chunk = Chunk.fromString(string);
            if (this.chunks.containsKey(chunk.id)) continue;
            if (chunk.block == Long.MAX_VALUE) {
                throw DataUtils.newIllegalStateException(6, "Chunk {0} is invalid", chunk.id);
            }
            this.chunks.put(chunk.id, chunk);
        }
    }

    private void setLastChunk(Chunk chunk) {
        this.lastChunk = chunk;
        if (chunk == null) {
            this.lastMapId = 0;
            this.currentVersion = 0L;
            this.meta.setRootPos(0L, -1L);
        } else {
            this.lastMapId = chunk.mapId;
            this.currentVersion = chunk.version;
            this.chunks.put(chunk.id, chunk);
            this.meta.setRootPos(chunk.metaRootPos, -1L);
        }
        this.setWriteVersion(this.currentVersion);
    }

    private void verifyLastChunks() {
        long l = this.getTimeSinceCreation();
        ArrayList arrayList = new ArrayList(this.chunks.keySet());
        Collections.sort(arrayList);
        int n = -1;
        Chunk chunk = null;
        Object object = arrayList.iterator();
        while (object.hasNext()) {
            Integer n2 = (Integer)object.next();
            Chunk chunk2 = this.chunks.get(n2);
            if (chunk != null && chunk2.time < chunk.time) break;
            chunk = chunk2;
            if (chunk2.time + (long)this.retentionTime < l) {
                n = chunk2.id;
                continue;
            }
            Chunk chunk3 = this.readChunkHeaderAndFooter(chunk2.block);
            if (chunk3 == null || chunk3.id != chunk2.id) break;
            n = n2;
        }
        if ((object = this.chunks.get(n)) != this.lastChunk) {
            this.rollbackTo(object == null ? 0L : ((Chunk)object).version);
        }
    }

    private Chunk readChunkHeaderAndFooter(long l) {
        Chunk chunk;
        try {
            chunk = this.readChunkHeader(l);
        }
        catch (Exception exception) {
            return null;
        }
        if (chunk == null) {
            return null;
        }
        Chunk chunk2 = this.readChunkFooter((l + (long)chunk.len) * 4096L);
        if (chunk2 == null || chunk2.id != chunk.id) {
            return null;
        }
        return chunk;
    }

    private Chunk readChunkFooter(long l) {
        try {
            ByteBuffer byteBuffer = this.fileStore.readFully(l - 128L, 128);
            byte[] byArray = new byte[128];
            byteBuffer.get(byArray);
            String string = new String(byArray, DataUtils.LATIN).trim();
            HashMap<String, String> hashMap = DataUtils.parseMap(string);
            int n = DataUtils.readHexInt(hashMap, "fletcher", 0);
            hashMap.remove("fletcher");
            string = string.substring(0, string.lastIndexOf("fletcher") - 1);
            byte[] byArray2 = string.getBytes(DataUtils.LATIN);
            int n2 = DataUtils.getFletcher32(byArray2, byArray2.length);
            if (n == n2) {
                int n3 = DataUtils.readHexInt(hashMap, "chunk", 0);
                Chunk chunk = new Chunk(n3);
                chunk.version = DataUtils.readHexLong(hashMap, "version", 0L);
                chunk.block = DataUtils.readHexLong(hashMap, "block", 0L);
                return chunk;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private void writeStoreHeader() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.lastChunk != null) {
            this.storeHeader.put("block", this.lastChunk.block);
            this.storeHeader.put("chunk", this.lastChunk.id);
            this.storeHeader.put("version", this.lastChunk.version);
        }
        DataUtils.appendMap(stringBuilder, this.storeHeader);
        byte[] byArray = stringBuilder.toString().getBytes(DataUtils.LATIN);
        int n = DataUtils.getFletcher32(byArray, byArray.length);
        DataUtils.appendMap(stringBuilder, "fletcher", n);
        stringBuilder.append("\n");
        byArray = stringBuilder.toString().getBytes(DataUtils.LATIN);
        ByteBuffer byteBuffer = ByteBuffer.allocate(8192);
        byteBuffer.put(byArray);
        byteBuffer.position(4096);
        byteBuffer.put(byArray);
        byteBuffer.rewind();
        this.write(0L, byteBuffer);
    }

    private void write(long l, ByteBuffer byteBuffer) {
        try {
            this.fileStore.writeFully(l, byteBuffer);
        }
        catch (IllegalStateException illegalStateException) {
            this.panic(illegalStateException);
            throw illegalStateException;
        }
    }

    public void close() {
        if (this.closed) {
            return;
        }
        FileStore fileStore = this.fileStore;
        if (fileStore != null && !fileStore.isReadOnly()) {
            this.stopBackgroundThread();
            if (this.hasUnsavedChanges()) {
                this.commitAndSave();
            }
        }
        this.closeStore(true);
    }

    public void closeImmediately() {
        block2: {
            try {
                this.closeStore(false);
            }
            catch (Exception exception) {
                if (this.backgroundExceptionHandler == null) break block2;
                this.backgroundExceptionHandler.uncaughtException(null, exception);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeStore(boolean bl) {
        if (this.closed) {
            return;
        }
        this.stopBackgroundThread();
        this.closed = true;
        if (this.fileStore == null) {
            return;
        }
        MVStore mVStore = this;
        synchronized (mVStore) {
            if (bl) {
                this.shrinkFileIfPossible(0);
            }
            this.cache = null;
            this.cacheChunkRef = null;
            for (MVMap<?, ?> mVMap : New.arrayList(this.maps.values())) {
                mVMap.close();
            }
            this.meta = null;
            this.chunks.clear();
            this.maps.clear();
            try {
                if (!this.fileStoreIsProvided) {
                    this.fileStore.close();
                }
            }
            finally {
                this.fileStore = null;
            }
        }
    }

    boolean isChunkLive(int n) {
        String string = this.meta.get(Chunk.getMetaKey(n));
        return string != null;
    }

    private Chunk getChunk(long l) {
        Chunk chunk = this.getChunkIfFound(l);
        if (chunk == null) {
            int n = DataUtils.getPageChunkId(l);
            throw DataUtils.newIllegalStateException(6, "Chunk {0} not found", n);
        }
        return chunk;
    }

    private Chunk getChunkIfFound(long l) {
        int n = DataUtils.getPageChunkId(l);
        Chunk chunk = this.chunks.get(n);
        if (chunk == null) {
            this.checkOpen();
            if (!Thread.holdsLock(this)) {
                throw DataUtils.newIllegalStateException(9, "Chunk {0} no longer exists", n);
            }
            String string = this.meta.get(Chunk.getMetaKey(n));
            if (string == null) {
                return null;
            }
            chunk = Chunk.fromString(string);
            if (chunk.block == Long.MAX_VALUE) {
                throw DataUtils.newIllegalStateException(6, "Chunk {0} is invalid", n);
            }
            this.chunks.put(chunk.id, chunk);
        }
        return chunk;
    }

    private void setWriteVersion(long l) {
        for (MVMap<?, ?> mVMap : this.maps.values()) {
            mVMap.setWriteVersion(l);
        }
        this.meta.setWriteVersion(l);
    }

    public long commit() {
        if (this.fileStore != null) {
            return this.commitAndSave();
        }
        long l = ++this.currentVersion;
        this.setWriteVersion(l);
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized long commitAndSave() {
        if (this.closed) {
            return this.currentVersion;
        }
        if (this.fileStore == null) {
            throw DataUtils.newIllegalStateException(2, "This is an in-memory store", new Object[0]);
        }
        if (this.currentStoreVersion >= 0L) {
            return this.currentVersion;
        }
        if (!this.hasUnsavedChanges()) {
            return this.currentVersion;
        }
        if (this.fileStore.isReadOnly()) {
            throw DataUtils.newIllegalStateException(2, "This store is read-only", new Object[0]);
        }
        try {
            this.currentStoreVersion = this.currentVersion;
            this.currentStoreThread = Thread.currentThread();
            long l = this.storeNow();
            return l;
        }
        finally {
            this.currentStoreVersion = -1L;
            this.currentStoreThread = null;
        }
    }

    private long storeNow() {
        try {
            return this.storeNowTry();
        }
        catch (IllegalStateException illegalStateException) {
            this.panic(illegalStateException);
            return -1L;
        }
    }

    private long storeNowTry() {
        long l;
        int n;
        boolean bl;
        Object object;
        Serializable serializable;
        Chunk chunk;
        int n2;
        long l2;
        this.freeUnusedChunks();
        int n3 = this.unsavedMemory;
        long l3 = this.currentStoreVersion;
        long l4 = ++this.currentVersion;
        this.setWriteVersion(l4);
        this.lastCommitTime = l2 = this.getTimeSinceCreation();
        this.retainChunk = null;
        if (this.lastChunk == null) {
            n2 = 0;
        } else {
            n2 = this.lastChunk.id;
            this.meta.put(Chunk.getMetaKey(n2), this.lastChunk.asString());
            l2 = Math.max(this.lastChunk.time, l2);
        }
        int n4 = n2;
        while ((chunk = this.chunks.get(n4 = (n4 + 1) % 0x3FFFFFF)) != null) {
            if (chunk.block != Long.MAX_VALUE) continue;
            serializable = DataUtils.newIllegalStateException(3, "Last block not stored, possibly due to out-of-memory", new Object[0]);
            this.panic((IllegalStateException)serializable);
        }
        chunk = new Chunk(n4);
        chunk.pageCount = Integer.MAX_VALUE;
        chunk.pageCountLive = Integer.MAX_VALUE;
        chunk.maxLen = Long.MAX_VALUE;
        chunk.maxLenLive = Long.MAX_VALUE;
        chunk.metaRootPos = Long.MAX_VALUE;
        chunk.block = Long.MAX_VALUE;
        chunk.len = Integer.MAX_VALUE;
        chunk.time = l2;
        chunk.version = l4;
        chunk.mapId = this.lastMapId;
        chunk.next = Long.MAX_VALUE;
        this.chunks.put(chunk.id, chunk);
        this.meta.put(Chunk.getMetaKey(chunk.id), chunk.asString());
        this.meta.remove(Chunk.getMetaKey(chunk.id));
        serializable = New.arrayList(this.maps.values());
        ArrayList<MVMap> arrayList = New.arrayList();
        Object object2 = ((ArrayList)serializable).iterator();
        while (object2.hasNext()) {
            MVMap mVMap = (MVMap)object2.next();
            mVMap.setWriteVersion(l4);
            long l5 = mVMap.getVersion();
            if (mVMap.getCreateVersion() > l3 || mVMap.isVolatile() || l5 < 0L || l5 < this.lastStoredVersion || ((MVMap)(object = mVMap.openVersion(l3))).getRoot().getPos() != 0L) continue;
            arrayList.add((MVMap)object);
        }
        this.applyFreedSpace(l3);
        object2 = this.getWriteBuffer();
        chunk.writeChunkHeader((WriteBuffer)object2, 0);
        int n5 = ((WriteBuffer)object2).position();
        chunk.pageCount = 0;
        chunk.pageCountLive = 0;
        chunk.maxLen = 0L;
        chunk.maxLenLive = 0L;
        for (MVMap mVMap : arrayList) {
            object = mVMap.getRoot();
            String string = MVMap.getMapRootKey(mVMap.getId());
            if (((Page)object).getTotalCount() == 0L) {
                this.meta.put(string, "0");
                continue;
            }
            ((Page)object).writeUnsavedRecursive(chunk, (WriteBuffer)object2);
            long l6 = ((Page)object).getPos();
            this.meta.put(string, Long.toHexString(l6));
        }
        this.meta.setWriteVersion(l4);
        Page page = this.meta.getRoot();
        page.writeUnsavedRecursive(chunk, (WriteBuffer)object2);
        int n6 = ((WriteBuffer)object2).position();
        int n7 = MathUtils.roundUpInt(n6 + 128, 4096);
        ((WriteBuffer)object2).limit(n7);
        long l7 = this.getFileLengthInUse();
        long l8 = this.reuseSpace ? this.fileStore.allocate(n7) : l7;
        boolean bl2 = bl = l8 + (long)n7 >= this.fileStore.size();
        if (!this.reuseSpace) {
            this.fileStore.markUsed(l7, n7);
        }
        chunk.block = l8 / 4096L;
        chunk.len = n7 / 4096;
        chunk.metaRootPos = page.getPos();
        if (this.reuseSpace) {
            n = chunk.len;
            l = this.fileStore.allocate(n * 4096);
            this.fileStore.free(l, n * 4096);
            chunk.next = l / 4096L;
        } else {
            chunk.next = 0L;
        }
        ((WriteBuffer)object2).position(0);
        chunk.writeChunkHeader((WriteBuffer)object2, n5);
        this.revertTemp(l3);
        ((WriteBuffer)object2).position(((WriteBuffer)object2).limit() - 128);
        ((WriteBuffer)object2).put(chunk.getFooterBytes());
        ((WriteBuffer)object2).position(0);
        this.write(l8, ((WriteBuffer)object2).getBuffer());
        this.releaseWriteBuffer((WriteBuffer)object2);
        n = 0;
        if (!bl) {
            if (this.lastChunk == null) {
                n = 1;
            } else if (this.lastChunk.next != chunk.block) {
                n = 1;
            } else {
                l = DataUtils.readHexLong(this.storeHeader, "version", 0L);
                if (this.lastChunk.version - l > 20L) {
                    n = 1;
                } else {
                    int n8 = DataUtils.readHexInt(this.storeHeader, "chunk", 0);
                    while (true) {
                        Chunk chunk2;
                        if ((chunk2 = this.chunks.get(n8)) == null) {
                            n = 1;
                            break;
                        }
                        if (n8 == this.lastChunk.id) break;
                        ++n8;
                    }
                }
            }
        }
        this.lastChunk = chunk;
        if (n != 0) {
            this.writeStoreHeader();
        }
        if (!bl) {
            this.shrinkFileIfPossible(1);
        }
        for (MVMap mVMap : arrayList) {
            Page page2 = mVMap.getRoot();
            if (page2.getTotalCount() <= 0L) continue;
            page2.writeEnd();
        }
        page.writeEnd();
        this.unsavedMemory = Math.max(0, this.unsavedMemory - n3);
        this.metaChanged = false;
        this.lastStoredVersion = l3;
        return l4;
    }

    private synchronized void freeUnusedChunks() {
        if (this.lastChunk == null || !this.reuseSpace) {
            return;
        }
        Set<Integer> set = this.collectReferencedChunks();
        ArrayList<Chunk> arrayList = New.arrayList();
        long l = this.getTimeSinceCreation();
        for (Chunk chunk : this.chunks.values()) {
            if (set.contains(chunk.id)) continue;
            arrayList.add(chunk);
        }
        for (Chunk chunk : arrayList) {
            if (this.canOverwriteChunk(chunk, l)) {
                this.chunks.remove(chunk.id);
                this.markMetaChanged();
                this.meta.remove(Chunk.getMetaKey(chunk.id));
                long l2 = chunk.block * 4096L;
                int n = chunk.len * 4096;
                this.fileStore.free(l2, n);
                continue;
            }
            if (chunk.unused != 0L) continue;
            chunk.unused = l;
            this.meta.put(Chunk.getMetaKey(chunk.id), chunk.asString());
            this.markMetaChanged();
        }
    }

    private Set<Integer> collectReferencedChunks() {
        String string;
        long l = this.lastChunk.version;
        DataUtils.checkArgument(l > 0L, "Collect references on version 0", new Object[0]);
        long l2 = this.getFileStore().readCount;
        HashSet<Integer> hashSet = New.hashSet();
        Cursor<String, String> cursor = this.meta.cursor("root.");
        while (cursor.hasNext() && (string = cursor.next()).startsWith("root.")) {
            long l3 = DataUtils.parseHexLong(cursor.getValue());
            if (l3 == 0L) continue;
            int n = DataUtils.parseHexInt(string.substring("root.".length()));
            this.collectReferencedChunks(hashSet, n, l3, 0);
        }
        long l4 = this.lastChunk.metaRootPos;
        this.collectReferencedChunks(hashSet, 0, l4, 0);
        l2 = this.fileStore.readCount - l2;
        return hashSet;
    }

    private void collectReferencedChunks(Set<Integer> set, int n, long l, int n2) {
        int n3 = DataUtils.getPageChunkId(l);
        set.add(n3);
        if (DataUtils.getPageType(l) == 0) {
            return;
        }
        Page.PageChildren pageChildren = this.readPageChunkReferences(n, l, -1);
        if (!pageChildren.chunkList) {
            HashSet hashSet = New.hashSet();
            for (int i = 0; i < pageChildren.children.length; ++i) {
                long l2 = pageChildren.children[i];
                this.collectReferencedChunks(hashSet, n, l2, n2 + 1);
            }
            hashSet.remove(n3);
            long[] lArray = new long[hashSet.size()];
            int n4 = 0;
            Iterator iterator = hashSet.iterator();
            while (iterator.hasNext()) {
                Integer n5 = (Integer)iterator.next();
                lArray[n4++] = DataUtils.getPagePos(n5, 0, 0, 0);
            }
            pageChildren.children = lArray;
            pageChildren.chunkList = true;
            if (this.cacheChunkRef != null) {
                this.cacheChunkRef.put(pageChildren.pos, pageChildren, pageChildren.getMemory());
            }
        }
        for (Object object : (HashSet)pageChildren.children) {
            set.add(DataUtils.getPageChunkId((long)object));
        }
    }

    private Page.PageChildren readPageChunkReferences(int n, long l, int n2) {
        int n3;
        if (DataUtils.getPageType(l) == 0) {
            return null;
        }
        Page.PageChildren pageChildren = this.cacheChunkRef != null ? this.cacheChunkRef.get(l) : null;
        if (pageChildren == null) {
            Object object;
            if (this.cache != null && (object = this.cache.get(l)) != null) {
                pageChildren = new Page.PageChildren((Page)object);
            }
            if (pageChildren == null) {
                object = this.getChunk(l);
                long l2 = ((Chunk)object).block * 4096L;
                if ((l2 += (long)DataUtils.getPageOffset(l)) < 0L) {
                    throw DataUtils.newIllegalStateException(6, "Negative position {0}; p={1}, c={2}", l2, l, ((Chunk)object).toString());
                }
                long l3 = (((Chunk)object).block + (long)((Chunk)object).len) * 4096L;
                pageChildren = Page.PageChildren.read(this.fileStore, l, n, l2, l3);
            }
            pageChildren.removeDuplicateChunkReferences();
            if (this.cacheChunkRef != null) {
                this.cacheChunkRef.put(l, pageChildren, pageChildren.getMemory());
            }
        }
        if (pageChildren.children.length == 0 && (n3 = DataUtils.getPageChunkId(l)) == n2) {
            return null;
        }
        return pageChildren;
    }

    private WriteBuffer getWriteBuffer() {
        WriteBuffer writeBuffer;
        if (this.writeBuffer != null) {
            writeBuffer = this.writeBuffer;
            writeBuffer.clear();
        } else {
            writeBuffer = new WriteBuffer();
        }
        return writeBuffer;
    }

    private void releaseWriteBuffer(WriteBuffer writeBuffer) {
        if (writeBuffer.capacity() <= 0x400000) {
            this.writeBuffer = writeBuffer;
        }
    }

    private boolean canOverwriteChunk(Chunk chunk, long l) {
        Chunk chunk2;
        if (this.retentionTime >= 0) {
            if (chunk.time + (long)this.retentionTime > l) {
                return false;
            }
            if (chunk.unused == 0L || chunk.unused + (long)(this.retentionTime / 2) > l) {
                return false;
            }
        }
        return (chunk2 = this.retainChunk) == null || chunk.version <= chunk2.version;
    }

    private long getTimeSinceCreation() {
        return Math.max(0L, this.getTimeAbsolute() - this.creationTime);
    }

    private long getTimeAbsolute() {
        long l = System.currentTimeMillis();
        if (this.lastTimeAbsolute != 0L && l < this.lastTimeAbsolute) {
            l = this.lastTimeAbsolute;
        } else {
            this.lastTimeAbsolute = l;
        }
        return l;
    }

    private void applyFreedSpace(long l) {
        ArrayList<Chunk> arrayList;
        do {
            arrayList = New.arrayList();
            Iterator<Map.Entry<Long, HashMap<Integer, Chunk>>> iterator = this.freedPageSpace.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<Long, HashMap<Integer, Chunk>> entry = iterator.next();
                long l2 = (Long)entry.getKey();
                if (l2 > l) continue;
                HashMap hashMap = (HashMap)entry.getValue();
                for (Chunk chunk : hashMap.values()) {
                    Chunk chunk2 = this.chunks.get(chunk.id);
                    if (chunk2 == null) continue;
                    chunk2.maxLenLive += chunk.maxLenLive;
                    chunk2.pageCountLive += chunk.pageCountLive;
                    if (chunk2.pageCountLive < 0 && chunk2.pageCountLive > -10000000) {
                        chunk2.pageCountLive = 0;
                    }
                    if (chunk2.maxLenLive < 0L && chunk2.maxLenLive > -10000000L) {
                        chunk2.maxLenLive = 0L;
                    }
                    arrayList.add(chunk2);
                }
                iterator.remove();
            }
            for (Chunk chunk : arrayList) {
                this.meta.put(Chunk.getMetaKey(chunk.id), chunk.asString());
            }
        } while (arrayList.size() != 0);
    }

    private void shrinkFileIfPossible(int n) {
        long l;
        long l2 = this.getFileLengthInUse();
        if (l2 >= (l = this.fileStore.size())) {
            return;
        }
        if (n > 0 && l - l2 < 4096L) {
            return;
        }
        int n2 = (int)(100L - l2 * 100L / l);
        if (n2 < n) {
            return;
        }
        if (!this.closed) {
            this.sync();
        }
        this.fileStore.truncate(l2);
    }

    private long getFileLengthInUse() {
        long l = 8192L;
        for (Chunk chunk : this.chunks.values()) {
            if (chunk.len == Integer.MAX_VALUE) continue;
            long l2 = (chunk.block + (long)chunk.len) * 4096L;
            l = Math.max(l, l2);
        }
        return l;
    }

    public boolean hasUnsavedChanges() {
        this.checkOpen();
        if (this.metaChanged) {
            return true;
        }
        for (MVMap<?, ?> mVMap : this.maps.values()) {
            long l;
            if (mVMap.isClosed() || (l = mVMap.getVersion()) < 0L || l <= this.lastStoredVersion) continue;
            return true;
        }
        return false;
    }

    private Chunk readChunkHeader(long l) {
        long l2 = l * 4096L;
        ByteBuffer byteBuffer = this.fileStore.readFully(l2, 1024);
        return Chunk.readChunkHeader(byteBuffer, l2);
    }

    public synchronized boolean compactRewriteFully() {
        this.checkOpen();
        if (this.lastChunk == null) {
            return false;
        }
        Iterator<MVMap<?, ?>> iterator = this.maps.values().iterator();
        while (iterator.hasNext()) {
            MVMap<?, ?> mVMap;
            MVMap<?, ?> mVMap2 = mVMap = iterator.next();
            Cursor<Object, ?> cursor = mVMap2.cursor(null);
            Page page = null;
            while (cursor.hasNext()) {
                cursor.next();
                Page page2 = cursor.getPage();
                if (page2 == page) continue;
                Object object = page2.getKey(0);
                Object object2 = page2.getValue(0);
                mVMap2.put(object, object2);
                page = page2;
            }
        }
        this.commitAndSave();
        return true;
    }

    public synchronized boolean compactMoveChunks() {
        return this.compactMoveChunks(100, Long.MAX_VALUE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean compactMoveChunks(int n, long l) {
        this.checkOpen();
        if (this.lastChunk == null || !this.reuseSpace) {
            return false;
        }
        int n2 = this.retentionTime;
        boolean bl = this.reuseSpace;
        try {
            this.retentionTime = -1;
            this.freeUnusedChunks();
            if (this.fileStore.getFillRate() > n) {
                boolean bl2 = false;
                return bl2;
            }
            long l2 = this.fileStore.getFirstFree() / 4096L;
            ArrayList<Chunk> arrayList = this.compactGetMoveBlocks(l2, l);
            this.compactMoveChunks(arrayList);
            this.freeUnusedChunks();
            this.storeNow();
        }
        finally {
            this.reuseSpace = bl;
            this.retentionTime = n2;
        }
        return true;
    }

    private ArrayList<Chunk> compactGetMoveBlocks(long l, long l2) {
        ArrayList<Chunk> arrayList = New.arrayList();
        for (Chunk chunk : this.chunks.values()) {
            if (chunk.block <= l) continue;
            arrayList.add(chunk);
        }
        Collections.sort(arrayList, new Comparator<Chunk>(){

            @Override
            public int compare(Chunk chunk, Chunk chunk2) {
                return Long.signum(chunk.block - chunk2.block);
            }
        });
        int n = 0;
        long l3 = 0L;
        for (Chunk chunk : arrayList) {
            long l4 = (long)chunk.len * 4096L;
            if (l3 + l4 > l2) break;
            l3 += l4;
            ++n;
        }
        while (arrayList.size() > n && arrayList.size() > 1) {
            arrayList.remove(1);
        }
        return arrayList;
    }

    private void compactMoveChunks(ArrayList<Chunk> arrayList) {
        long l;
        int n;
        ByteBuffer byteBuffer;
        int n2;
        long l2;
        WriteBuffer writeBuffer;
        for (Chunk chunk : arrayList) {
            writeBuffer = this.getWriteBuffer();
            l2 = chunk.block * 4096L;
            n2 = chunk.len * 4096;
            writeBuffer.limit(n2);
            byteBuffer = this.fileStore.readFully(l2, n2);
            Chunk.readChunkHeader(byteBuffer, l2);
            n = byteBuffer.position();
            writeBuffer.position(n);
            writeBuffer.put(byteBuffer);
            l = this.getFileLengthInUse();
            this.fileStore.markUsed(l, n2);
            this.fileStore.free(l2, n2);
            chunk.block = l / 4096L;
            chunk.next = 0L;
            writeBuffer.position(0);
            chunk.writeChunkHeader(writeBuffer, n);
            writeBuffer.position(n2 - 128);
            writeBuffer.put(chunk.getFooterBytes());
            writeBuffer.position(0);
            this.write(l, writeBuffer.getBuffer());
            this.releaseWriteBuffer(writeBuffer);
            this.markMetaChanged();
            this.meta.put(Chunk.getMetaKey(chunk.id), chunk.asString());
        }
        this.reuseSpace = false;
        this.commitAndSave();
        this.sync();
        this.reuseSpace = true;
        for (Chunk chunk : arrayList) {
            if (!this.chunks.containsKey(chunk.id)) continue;
            writeBuffer = this.getWriteBuffer();
            l2 = chunk.block * 4096L;
            n2 = chunk.len * 4096;
            writeBuffer.limit(n2);
            byteBuffer = this.fileStore.readFully(l2, n2);
            Chunk.readChunkHeader(byteBuffer, 0L);
            n = byteBuffer.position();
            writeBuffer.position(n);
            writeBuffer.put(byteBuffer);
            l = this.fileStore.allocate(n2);
            this.fileStore.free(l2, n2);
            writeBuffer.position(0);
            chunk.block = l / 4096L;
            chunk.writeChunkHeader(writeBuffer, n);
            writeBuffer.position(n2 - 128);
            writeBuffer.put(chunk.getFooterBytes());
            writeBuffer.position(0);
            this.write(l, writeBuffer.getBuffer());
            this.releaseWriteBuffer(writeBuffer);
            this.markMetaChanged();
            this.meta.put(Chunk.getMetaKey(chunk.id), chunk.asString());
        }
        this.commitAndSave();
        this.sync();
        this.shrinkFileIfPossible(0);
    }

    public void sync() {
        this.checkOpen();
        FileStore fileStore = this.fileStore;
        if (fileStore != null) {
            fileStore.sync();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean compact(int n, int n2) {
        if (!this.reuseSpace) {
            return false;
        }
        Object object = this.compactSync;
        synchronized (object) {
            ArrayList<Chunk> arrayList;
            this.checkOpen();
            MVStore mVStore = this;
            synchronized (mVStore) {
                arrayList = this.compactGetOldChunks(n, n2);
            }
            if (arrayList == null || arrayList.size() == 0) {
                return false;
            }
            this.compactRewrite(arrayList);
            return true;
        }
    }

    private ArrayList<Chunk> compactGetOldChunks(int n, int n2) {
        Object object3;
        int n3;
        if (this.lastChunk == null) {
            return null;
        }
        long l = 0L;
        long l2 = 0L;
        long l3 = this.getTimeSinceCreation();
        for (Chunk object22 : this.chunks.values()) {
            if (object22.time + (long)this.retentionTime > l3) continue;
            l += object22.maxLen;
            l2 += object22.maxLenLive;
        }
        if (l2 < 0L) {
            return null;
        }
        if (l <= 0L) {
            l = 1L;
        }
        if ((n3 = (int)(100L * l2 / l)) >= n) {
            return null;
        }
        ArrayList<Chunk> arrayList = New.arrayList();
        Chunk chunk = this.chunks.get(this.lastChunk.id);
        for (Chunk chunk2 : this.chunks.values()) {
            if (chunk2.time + (long)this.retentionTime > l3) continue;
            long n4 = chunk.version - chunk2.version + 1L;
            chunk2.collectPriority = (int)((long)(chunk2.getFillRate() * 1000) / n4);
            arrayList.add(chunk2);
        }
        if (arrayList.size() == 0) {
            return null;
        }
        Collections.sort(arrayList, new Comparator<Chunk>(){

            @Override
            public int compare(Chunk chunk, Chunk chunk2) {
                int n = new Integer(chunk.collectPriority).compareTo(chunk2.collectPriority);
                if (n == 0) {
                    n = new Long(chunk.maxLenLive).compareTo(chunk2.maxLenLive);
                }
                return n;
            }
        });
        long l4 = 0L;
        int n4 = 0;
        Object object2 = null;
        for (Object object3 : arrayList) {
            if (object2 != null && ((Chunk)object3).collectPriority > 0 && l4 > (long)n2) break;
            l4 += ((Chunk)object3).maxLenLive;
            ++n4;
            object2 = object3;
        }
        if (n4 < 1) {
            return null;
        }
        boolean bl = false;
        object3 = arrayList.iterator();
        while (object3.hasNext()) {
            Chunk chunk3 = (Chunk)object3.next();
            if (object2 == chunk3) {
                bl = true;
                continue;
            }
            if (!bl) continue;
            object3.remove();
        }
        return arrayList;
    }

    private void compactRewrite(ArrayList<Chunk> arrayList) {
        HashSet<Integer> hashSet = New.hashSet();
        for (Chunk object : arrayList) {
            hashSet.add(object.id);
        }
        for (MVMap mVMap : this.maps.values()) {
            MVMap mVMap2 = mVMap;
            if (mVMap2.rewrite(hashSet)) continue;
            return;
        }
        if (!this.meta.rewrite(hashSet)) {
            return;
        }
        this.freeUnusedChunks();
        this.commitAndSave();
    }

    Page readPage(MVMap<?, ?> mVMap, long l) {
        Page page;
        if (l == 0L) {
            throw DataUtils.newIllegalStateException(6, "Position 0", new Object[0]);
        }
        Page page2 = page = this.cache == null ? null : this.cache.get(l);
        if (page == null) {
            Chunk chunk = this.getChunk(l);
            long l2 = chunk.block * 4096L;
            if ((l2 += (long)DataUtils.getPageOffset(l)) < 0L) {
                throw DataUtils.newIllegalStateException(6, "Negative position {0}", l2);
            }
            long l3 = (chunk.block + (long)chunk.len) * 4096L;
            page = Page.read(this.fileStore, l, mVMap, l2, l3);
            this.cachePage(l, page, page.getMemory());
        }
        return page;
    }

    void removePage(MVMap<?, ?> mVMap, long l, int n) {
        if (l == 0L) {
            this.unsavedMemory = Math.max(0, this.unsavedMemory - n);
            return;
        }
        if (this.cache != null && DataUtils.getPageType(l) == 0) {
            this.cache.remove(l);
        }
        Chunk chunk = this.getChunk(l);
        long l2 = this.currentVersion;
        if (mVMap == this.meta && this.currentStoreVersion >= 0L && Thread.currentThread() == this.currentStoreThread) {
            l2 = this.currentStoreVersion;
        }
        this.registerFreePage(l2, chunk.id, DataUtils.getPageMaxLength(l), 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerFreePage(long l, int n, long l2, int n2) {
        HashMap<Integer, Chunk> hashMap;
        HashMap<Integer, Chunk> hashMap2 = this.freedPageSpace.get(l);
        if (hashMap2 == null) {
            hashMap2 = New.hashMap();
            hashMap = this.freedPageSpace.putIfAbsent(l, hashMap2);
            if (hashMap != null) {
                hashMap2 = hashMap;
            }
        }
        hashMap = hashMap2;
        synchronized (hashMap) {
            Chunk chunk = hashMap2.get(n);
            if (chunk == null) {
                chunk = new Chunk(n);
                hashMap2.put(n, chunk);
            }
            chunk.maxLenLive -= l2;
            chunk.pageCountLive -= n2;
        }
    }

    Compressor getCompressorFast() {
        if (this.compressorFast == null) {
            this.compressorFast = new CompressLZF();
        }
        return this.compressorFast;
    }

    Compressor getCompressorHigh() {
        if (this.compressorHigh == null) {
            this.compressorHigh = new CompressDeflate();
        }
        return this.compressorHigh;
    }

    int getCompressionLevel() {
        return this.compressionLevel;
    }

    public int getPageSplitSize() {
        return this.pageSplitSize;
    }

    public boolean getReuseSpace() {
        return this.reuseSpace;
    }

    public void setReuseSpace(boolean bl) {
        this.reuseSpace = bl;
    }

    public int getRetentionTime() {
        return this.retentionTime;
    }

    public void setRetentionTime(int n) {
        this.retentionTime = n;
    }

    public void setVersionsToKeep(int n) {
        this.versionsToKeep = n;
    }

    public long getVersionsToKeep() {
        return this.versionsToKeep;
    }

    long getOldestVersionToKeep() {
        long l = this.currentVersion;
        if (this.fileStore == null) {
            return l - (long)this.versionsToKeep;
        }
        long l2 = this.currentStoreVersion;
        if (l2 > -1L) {
            l = Math.min(l, l2);
        }
        return l;
    }

    private boolean isKnownVersion(long l) {
        if (l > this.currentVersion || l < 0L) {
            return false;
        }
        if (l == this.currentVersion || this.chunks.size() == 0) {
            return true;
        }
        Chunk chunk = this.getChunkForVersion(l);
        if (chunk == null) {
            return false;
        }
        MVMap<String, String> mVMap = this.getMetaMap(l);
        if (mVMap == null) {
            return false;
        }
        try {
            String string;
            Iterator<String> iterator = mVMap.keyIterator("chunk.");
            while (iterator.hasNext() && (string = iterator.next()).startsWith("chunk.")) {
                if (this.meta.containsKey(string)) continue;
                String string2 = mVMap.get(string);
                Chunk chunk2 = Chunk.fromString(string2);
                Chunk chunk3 = this.readChunkHeaderAndFooter(chunk2.block);
                if (chunk3 == null || chunk3.id != chunk2.id) {
                    return false;
                }
                this.chunks.put(chunk2.id, chunk2);
            }
        }
        catch (IllegalStateException illegalStateException) {
            return false;
        }
        return true;
    }

    void registerUnsavedPage(int n) {
        this.unsavedMemory += n;
        int n2 = this.unsavedMemory;
        if (n2 > this.autoCommitMemory && this.autoCommitMemory > 0) {
            this.saveNeeded = true;
        }
    }

    void beforeWrite(MVMap<?, ?> mVMap) {
        if (this.saveNeeded) {
            if (mVMap == this.meta) {
                return;
            }
            this.saveNeeded = false;
            if (this.unsavedMemory > this.autoCommitMemory && this.autoCommitMemory > 0) {
                this.commitAndSave();
            }
        }
    }

    public int getStoreVersion() {
        this.checkOpen();
        String string = this.meta.get("setting.storeVersion");
        return string == null ? 0 : DataUtils.parseHexInt(string);
    }

    public synchronized void setStoreVersion(int n) {
        this.checkOpen();
        this.markMetaChanged();
        this.meta.put("setting.storeVersion", Integer.toHexString(n));
    }

    public void rollback() {
        this.rollbackTo(this.currentVersion);
    }

    public synchronized void rollbackTo(long l) {
        this.checkOpen();
        if (l == 0L) {
            for (MVMap<?, ?> mVMap : this.maps.values()) {
                mVMap.close();
            }
            this.meta.clear();
            this.chunks.clear();
            if (this.fileStore != null) {
                this.fileStore.clear();
            }
            this.maps.clear();
            this.freedPageSpace.clear();
            this.currentVersion = l;
            this.setWriteVersion(l);
            this.metaChanged = false;
            return;
        }
        DataUtils.checkArgument(this.isKnownVersion(l), "Unknown version {0}", l);
        for (MVMap<?, ?> object2 : this.maps.values()) {
            object2.rollbackTo(l);
        }
        for (long i = this.currentVersion; i >= l && this.freedPageSpace.size() != 0; --i) {
            this.freedPageSpace.remove(i);
        }
        this.meta.rollbackTo(l);
        this.metaChanged = false;
        boolean bl = false;
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        Chunk chunk = null;
        for (Chunk n : this.chunks.values()) {
            if (n.version > l) {
                arrayList.add(n.id);
                continue;
            }
            if (chunk != null && chunk.id >= n.id) continue;
            chunk = n;
        }
        if (arrayList.size() > 0) {
            Collections.sort(arrayList, Collections.reverseOrder());
            this.revertTemp(l);
            bl = true;
            Iterator<Object> iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                int n = (Integer)iterator.next();
                Chunk chunk2 = this.chunks.remove(n);
                long l2 = chunk2.block * 4096L;
                int n2 = chunk2.len * 4096;
                this.fileStore.free(l2, n2);
                WriteBuffer writeBuffer = this.getWriteBuffer();
                writeBuffer.limit(n2);
                Arrays.fill(writeBuffer.getBuffer().array(), (byte)0);
                this.write(l2, writeBuffer.getBuffer());
                this.releaseWriteBuffer(writeBuffer);
                this.sync();
            }
            this.lastChunk = chunk;
            this.writeStoreHeader();
            this.readStoreHeader();
        }
        for (MVMap mVMap : New.arrayList(this.maps.values())) {
            int n = mVMap.getId();
            if (mVMap.getCreateVersion() >= l) {
                mVMap.close();
                this.maps.remove(n);
                continue;
            }
            if (!bl) continue;
            mVMap.setRootPos(MVStore.getRootPos(this.meta, n), -1L);
        }
        if (this.lastChunk != null) {
            for (Chunk chunk3 : this.chunks.values()) {
                this.meta.put(Chunk.getMetaKey(chunk3.id), chunk3.asString());
            }
        }
        this.currentVersion = l;
        this.setWriteVersion(l);
    }

    private static long getRootPos(MVMap<String, String> mVMap, int n) {
        String string = mVMap.get(MVMap.getMapRootKey(n));
        return string == null ? 0L : DataUtils.parseHexLong(string);
    }

    private void revertTemp(long l) {
        Iterator<Object> iterator = this.freedPageSpace.keySet().iterator();
        while (iterator.hasNext()) {
            long l2 = (Long)iterator.next();
            if (l2 > l) continue;
            iterator.remove();
        }
        for (MVMap mVMap : this.maps.values()) {
            mVMap.removeUnusedOldVersions();
        }
    }

    public long getCurrentVersion() {
        return this.currentVersion;
    }

    public FileStore getFileStore() {
        return this.fileStore;
    }

    public Map<String, Object> getStoreHeader() {
        return this.storeHeader;
    }

    private void checkOpen() {
        if (this.closed) {
            throw DataUtils.newIllegalStateException(4, "This store is closed", this.panicException);
        }
    }

    public synchronized void renameMap(MVMap<?, ?> mVMap, String string) {
        this.checkOpen();
        DataUtils.checkArgument(mVMap != this.meta, "Renaming the meta map is not allowed", new Object[0]);
        int n = mVMap.getId();
        String string2 = this.getMapName(n);
        if (string2.equals(string)) {
            return;
        }
        DataUtils.checkArgument(!this.meta.containsKey("name." + string), "A map named {0} already exists", string);
        this.markMetaChanged();
        String string3 = Integer.toHexString(n);
        this.meta.remove("name." + string2);
        this.meta.put(MVMap.getMapKey(n), mVMap.asString(string));
        this.meta.put("name." + string, string3);
    }

    public synchronized void removeMap(MVMap<?, ?> mVMap) {
        this.checkOpen();
        DataUtils.checkArgument(mVMap != this.meta, "Removing the meta map is not allowed", new Object[0]);
        mVMap.clear();
        int n = mVMap.getId();
        String string = this.getMapName(n);
        this.markMetaChanged();
        this.meta.remove(MVMap.getMapKey(n));
        this.meta.remove("name." + string);
        this.meta.remove(MVMap.getMapRootKey(n));
        this.maps.remove(n);
    }

    public synchronized String getMapName(int n) {
        this.checkOpen();
        String string = this.meta.get(MVMap.getMapKey(n));
        return string == null ? null : DataUtils.parseMap(string).get("name");
    }

    void writeInBackground() {
        block9: {
            block8: {
                if (this.closed) {
                    return;
                }
                long l = this.getTimeSinceCreation();
                if (l <= this.lastCommitTime + (long)this.autoCommitDelay) {
                    return;
                }
                if (this.hasUnsavedChanges()) {
                    try {
                        this.commitAndSave();
                    }
                    catch (Exception exception) {
                        if (this.backgroundExceptionHandler == null) break block8;
                        this.backgroundExceptionHandler.uncaughtException(null, exception);
                        return;
                    }
                }
            }
            if (this.autoCompactFillRate > 0) {
                try {
                    long l = this.fileStore.getWriteCount() + this.fileStore.getReadCount();
                    boolean bl = this.autoCompactLastFileOpCount != l;
                    int n = bl ? this.autoCompactFillRate / 3 : this.autoCompactFillRate;
                    this.compact(n, this.autoCommitMemory);
                    this.autoCompactLastFileOpCount = this.fileStore.getWriteCount() + this.fileStore.getReadCount();
                }
                catch (Exception exception) {
                    if (this.backgroundExceptionHandler == null) break block9;
                    this.backgroundExceptionHandler.uncaughtException(null, exception);
                }
            }
        }
    }

    public void setCacheSize(int n) {
        if (this.cache != null) {
            this.cache.setMaxMemory((long)n * 1024L * 1024L);
            this.cache.clear();
        }
    }

    public boolean isClosed() {
        return this.closed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopBackgroundThread() {
        BackgroundWriterThread backgroundWriterThread = this.backgroundWriterThread;
        if (backgroundWriterThread == null) {
            return;
        }
        this.backgroundWriterThread = null;
        if (Thread.currentThread() == backgroundWriterThread) {
            return;
        }
        Object object = backgroundWriterThread.sync;
        synchronized (object) {
            backgroundWriterThread.sync.notifyAll();
        }
        if (Thread.holdsLock(this)) {
            return;
        }
        try {
            backgroundWriterThread.join();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setAutoCommitDelay(int n) {
        if (this.autoCommitDelay == n) {
            return;
        }
        this.autoCommitDelay = n;
        if (this.fileStore == null || this.fileStore.isReadOnly()) {
            return;
        }
        this.stopBackgroundThread();
        if (n > 0) {
            int n2 = Math.max(1, n / 10);
            BackgroundWriterThread backgroundWriterThread = new BackgroundWriterThread(this, n2, this.fileStore.toString());
            backgroundWriterThread.start();
            this.backgroundWriterThread = backgroundWriterThread;
        }
    }

    public int getAutoCommitDelay() {
        return this.autoCommitDelay;
    }

    public int getAutoCommitMemory() {
        return this.autoCommitMemory;
    }

    public int getUnsavedMemory() {
        return this.unsavedMemory;
    }

    void cachePage(long l, Page page, int n) {
        if (this.cache != null) {
            this.cache.put(l, page, n);
        }
    }

    public int getCacheSizeUsed() {
        if (this.cache == null) {
            return 0;
        }
        return (int)(this.cache.getUsedMemory() / 1024L / 1024L);
    }

    public int getCacheSize() {
        if (this.cache == null) {
            return 0;
        }
        return (int)(this.cache.getMaxMemory() / 1024L / 1024L);
    }

    public CacheLongKeyLIRS<Page> getCache() {
        return this.cache;
    }

    public static class Builder {
        private final HashMap<String, Object> config = New.hashMap();

        private Builder set(String string, Object object) {
            this.config.put(string, object);
            return this;
        }

        public Builder autoCommitDisabled() {
            this.set("autoCommitBufferSize", 0);
            return this.set("autoCommitDelay", 0);
        }

        public Builder autoCommitBufferSize(int n) {
            return this.set("autoCommitBufferSize", n);
        }

        public Builder autoCompactFillRate(int n) {
            return this.set("autoCompactFillRate", n);
        }

        public Builder fileName(String string) {
            return this.set("fileName", string);
        }

        public Builder encryptionKey(char[] cArray) {
            return this.set("encryptionKey", cArray);
        }

        public Builder readOnly() {
            return this.set("readOnly", 1);
        }

        public Builder cacheSize(int n) {
            return this.set("cacheSize", n);
        }

        public Builder compress() {
            return this.set("compress", 1);
        }

        public Builder compressHigh() {
            return this.set("compress", 2);
        }

        public Builder pageSplitSize(int n) {
            return this.set("pageSplitSize", n);
        }

        public Builder backgroundExceptionHandler(Thread.UncaughtExceptionHandler uncaughtExceptionHandler) {
            return this.set("backgroundExceptionHandler", uncaughtExceptionHandler);
        }

        public Builder fileStore(FileStore fileStore) {
            return this.set("fileStore", fileStore);
        }

        public MVStore open() {
            return new MVStore(this.config);
        }

        public String toString() {
            return DataUtils.appendMap(new StringBuilder(), this.config).toString();
        }

        public static Builder fromString(String string) {
            HashMap<String, String> hashMap = DataUtils.parseMap(string);
            Builder builder = new Builder();
            builder.config.putAll(hashMap);
            return builder;
        }
    }

    private static class BackgroundWriterThread
    extends Thread {
        public final Object sync = new Object();
        private final MVStore store;
        private final int sleep;

        BackgroundWriterThread(MVStore mVStore, int n, String string) {
            super("MVStore background writer " + string);
            this.store = mVStore;
            this.sleep = n;
            this.setDaemon(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            BackgroundWriterThread backgroundWriterThread;
            while ((backgroundWriterThread = this.store.backgroundWriterThread) != null) {
                Object object = this.sync;
                synchronized (object) {
                    try {
                        this.sync.wait(this.sleep);
                    }
                    catch (InterruptedException interruptedException) {
                        continue;
                    }
                }
                this.store.writeInBackground();
            }
        }
    }
}

