/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.ascii.memcache;

import com.hazelcast.ascii.TextCommand;
import com.hazelcast.ascii.TextCommandConstants;
import com.hazelcast.ascii.TypeAwareCommandParser;
import com.hazelcast.ascii.memcache.ErrorCommand;
import com.hazelcast.ascii.memcache.IncrementCommand;
import com.hazelcast.nio.ascii.SocketTextReader;
import java.util.StringTokenizer;

public class IncrementCommandParser
extends TypeAwareCommandParser {
    public IncrementCommandParser(TextCommandConstants.TextCommandType type) {
        super(type);
    }

    @Override
    public TextCommand parser(SocketTextReader socketTextReader, String cmd, int space) {
        StringTokenizer st = new StringTokenizer(cmd);
        st.nextToken();
        String key = null;
        int value = 0;
        boolean noReply = false;
        if (!st.hasMoreTokens()) {
            return new ErrorCommand(TextCommandConstants.TextCommandType.ERROR_CLIENT);
        }
        key = st.nextToken();
        if (!st.hasMoreTokens()) {
            return new ErrorCommand(TextCommandConstants.TextCommandType.ERROR_CLIENT);
        }
        value = Integer.parseInt(st.nextToken());
        if (st.hasMoreTokens()) {
            noReply = "noreply".equals(st.nextToken());
        }
        return new IncrementCommand(this.type, key, value, noReply);
    }
}

