/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.concurrent.lock;

import com.hazelcast.concurrent.lock.ConditionKey;
import com.hazelcast.concurrent.lock.LockResource;
import com.hazelcast.concurrent.lock.LockResourceImpl;
import com.hazelcast.concurrent.lock.LockServiceImpl;
import com.hazelcast.concurrent.lock.LockStore;
import com.hazelcast.concurrent.lock.operations.AwaitOperation;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.nio.serialization.DataSerializable;
import com.hazelcast.spi.ObjectNamespace;
import com.hazelcast.util.ConcurrencyUtil;
import com.hazelcast.util.ConstructorFunction;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public final class LockStoreImpl
implements DataSerializable,
LockStore {
    private final transient ConstructorFunction<Data, LockResourceImpl> lockConstructor = new ConstructorFunction<Data, LockResourceImpl>(){

        @Override
        public LockResourceImpl createNew(Data key) {
            return new LockResourceImpl(key, LockStoreImpl.this);
        }
    };
    private final ConcurrentMap<Data, LockResourceImpl> locks = new ConcurrentHashMap<Data, LockResourceImpl>();
    private ObjectNamespace namespace;
    private int backupCount;
    private int asyncBackupCount;
    private LockServiceImpl lockService;

    public LockStoreImpl() {
    }

    public LockStoreImpl(LockServiceImpl lockService, ObjectNamespace name, int backupCount, int asyncBackupCount) {
        this.namespace = name;
        this.backupCount = backupCount;
        this.asyncBackupCount = asyncBackupCount;
        this.lockService = lockService;
    }

    public boolean lock(Data key, String caller, long threadId) {
        return this.lock(key, caller, threadId, Long.MAX_VALUE);
    }

    @Override
    public boolean lock(Data key, String caller, long threadId, long leaseTime) {
        LockResourceImpl lock = this.getLock(key);
        return lock.lock(caller, threadId, leaseTime);
    }

    @Override
    public boolean txnLock(Data key, String caller, long threadId, long leaseTime) {
        LockResourceImpl lock = this.getLock(key);
        return lock.lock(caller, threadId, leaseTime, true);
    }

    @Override
    public boolean extendLeaseTime(Data key, String caller, long threadId, long leaseTime) {
        LockResourceImpl lock = (LockResourceImpl)this.locks.get(key);
        if (lock == null) {
            return false;
        }
        return lock.extendLeaseTime(caller, threadId, leaseTime);
    }

    private LockResourceImpl getLock(Data key) {
        return ConcurrencyUtil.getOrPutIfAbsent(this.locks, key, this.lockConstructor);
    }

    @Override
    public boolean isLocked(Data key) {
        LockResource lock = (LockResource)this.locks.get(key);
        return lock != null && lock.isLocked();
    }

    @Override
    public boolean isLockedBy(Data key, String caller, long threadId) {
        LockResource lock = (LockResource)this.locks.get(key);
        if (lock == null) {
            return false;
        }
        return lock.isLockedBy(caller, threadId);
    }

    @Override
    public int getLockCount(Data key) {
        LockResource lock = (LockResource)this.locks.get(key);
        if (lock == null) {
            return 0;
        }
        return lock.getLockCount();
    }

    @Override
    public long getRemainingLeaseTime(Data key) {
        LockResource lock = (LockResource)this.locks.get(key);
        if (lock == null) {
            return -1L;
        }
        return lock.getRemainingLeaseTime();
    }

    @Override
    public boolean canAcquireLock(Data key, String caller, long threadId) {
        LockResourceImpl lock = (LockResourceImpl)this.locks.get(key);
        if (lock == null) {
            return true;
        }
        return lock.canAcquireLock(caller, threadId);
    }

    @Override
    public boolean unlock(Data key, String caller, long threadId) {
        LockResourceImpl lock = (LockResourceImpl)this.locks.get(key);
        if (lock == null) {
            return false;
        }
        boolean result = false;
        if (lock.canAcquireLock(caller, threadId) && lock.unlock(caller, threadId)) {
            result = true;
        }
        if (lock.isRemovable()) {
            this.locks.remove(key);
        }
        return result;
    }

    @Override
    public boolean forceUnlock(Data key) {
        LockResourceImpl lock = (LockResourceImpl)this.locks.get(key);
        if (lock == null) {
            return false;
        }
        lock.clear();
        if (lock.isRemovable()) {
            this.locks.remove(key);
            lock.cancelEviction();
        }
        return true;
    }

    public int getVersion(Data key) {
        LockResourceImpl lock = (LockResourceImpl)this.locks.get(key);
        if (lock != null) {
            return lock.getVersion();
        }
        return -1;
    }

    public Collection<LockResource> getLocks() {
        return Collections.unmodifiableCollection(this.locks.values());
    }

    @Override
    public Set<Data> getLockedKeys() {
        HashSet<Data> keySet = new HashSet<Data>(this.locks.size());
        for (Map.Entry entry : this.locks.entrySet()) {
            Data key = (Data)entry.getKey();
            LockResource lock = (LockResource)entry.getValue();
            if (!lock.isLocked()) continue;
            keySet.add(key);
        }
        return keySet;
    }

    void scheduleEviction(Data key, int version, long leaseTime) {
        this.lockService.scheduleEviction(this.namespace, key, version, leaseTime);
    }

    void cancelEviction(Data key) {
        this.lockService.cancelEviction(this.namespace, key);
    }

    void setLockService(LockServiceImpl lockService) {
        this.lockService = lockService;
    }

    public void clear() {
        this.locks.clear();
    }

    public ObjectNamespace getNamespace() {
        return this.namespace;
    }

    public int getBackupCount() {
        return this.backupCount;
    }

    public int getAsyncBackupCount() {
        return this.asyncBackupCount;
    }

    public int getTotalBackupCount() {
        return this.backupCount + this.asyncBackupCount;
    }

    public boolean addAwait(Data key, String conditionId, String caller, long threadId) {
        LockResourceImpl lock = this.getLock(key);
        return lock.addAwait(conditionId, caller, threadId);
    }

    public boolean removeAwait(Data key, String conditionId, String caller, long threadId) {
        LockResourceImpl lock = this.getLock(key);
        return lock.removeAwait(conditionId, caller, threadId);
    }

    public boolean startAwaiting(Data key, String conditionId, String caller, long threadId) {
        LockResourceImpl lock = this.getLock(key);
        return lock.startAwaiting(conditionId, caller, threadId);
    }

    public int getAwaitCount(Data key, String conditionId) {
        LockResourceImpl lock = this.getLock(key);
        return lock.getAwaitCount(conditionId);
    }

    public void registerSignalKey(ConditionKey conditionKey) {
        LockResourceImpl lock = this.getLock(conditionKey.getKey());
        lock.registerSignalKey(conditionKey);
    }

    public ConditionKey getSignalKey(Data key) {
        LockResourceImpl lock = (LockResourceImpl)this.locks.get(key);
        if (lock == null) {
            return null;
        }
        return lock.getSignalKey();
    }

    public void removeSignalKey(ConditionKey conditionKey) {
        LockResourceImpl lock = (LockResourceImpl)this.locks.get(conditionKey.getKey());
        if (lock != null) {
            lock.removeSignalKey(conditionKey);
        }
    }

    public void registerExpiredAwaitOp(AwaitOperation awaitResponse) {
        Data key = awaitResponse.getKey();
        LockResourceImpl lock = this.getLock(key);
        lock.registerExpiredAwaitOp(awaitResponse);
    }

    public AwaitOperation pollExpiredAwaitOp(Data key) {
        LockResourceImpl lock = (LockResourceImpl)this.locks.get(key);
        if (lock == null) {
            return null;
        }
        return lock.pollExpiredAwaitOp();
    }

    @Override
    public String getOwnerInfo(Data key) {
        LockResource lock = (LockResource)this.locks.get(key);
        if (lock == null) {
            return "<not-locked>";
        }
        return "Owner: " + lock.getOwner() + ", thread-id: " + lock.getThreadId();
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeObject(this.namespace);
        out.writeInt(this.backupCount);
        out.writeInt(this.asyncBackupCount);
        int len = this.locks.size();
        out.writeInt(len);
        if (len > 0) {
            for (LockResourceImpl lock : this.locks.values()) {
                lock.writeData(out);
            }
        }
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        this.namespace = (ObjectNamespace)in.readObject();
        this.backupCount = in.readInt();
        this.asyncBackupCount = in.readInt();
        int len = in.readInt();
        if (len > 0) {
            for (int i = 0; i < len; ++i) {
                LockResourceImpl lock = new LockResourceImpl();
                lock.readData(in);
                lock.setLockStore(this);
                this.locks.put(lock.getKey(), lock);
            }
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("LockStoreImpl");
        sb.append("{namespace=").append(this.namespace);
        sb.append(", backupCount=").append(this.backupCount);
        sb.append(", asyncBackupCount=").append(this.asyncBackupCount);
        sb.append('}');
        return sb.toString();
    }
}

