/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.multimap.impl.txn;

import com.hazelcast.multimap.impl.MultiMapContainer;
import com.hazelcast.multimap.impl.MultiMapRecord;
import com.hazelcast.multimap.impl.MultiMapWrapper;
import com.hazelcast.multimap.impl.operations.MultiMapKeyBasedOperation;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.Data;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

public class TxnRemoveAllBackupOperation
extends MultiMapKeyBasedOperation {
    Collection<Long> recordIds;

    public TxnRemoveAllBackupOperation() {
    }

    public TxnRemoveAllBackupOperation(String name, Data dataKey, Collection<Long> recordIds) {
        super(name, dataKey);
        this.recordIds = recordIds;
    }

    @Override
    public void run() throws Exception {
        MultiMapContainer container = this.getOrCreateContainer();
        MultiMapWrapper wrapper = container.getOrCreateMultiMapWrapper(this.dataKey);
        this.response = true;
        for (Long recordId : this.recordIds) {
            if (wrapper.containsRecordId(recordId)) continue;
            this.response = false;
            return;
        }
        Collection<MultiMapRecord> coll = wrapper.getCollection(false);
        block1: for (Long recordId : this.recordIds) {
            Iterator<MultiMapRecord> iter = coll.iterator();
            while (iter.hasNext()) {
                MultiMapRecord record = iter.next();
                if (record.getRecordId() != recordId.longValue()) continue;
                iter.remove();
                continue block1;
            }
        }
        if (coll.isEmpty()) {
            this.delete();
        }
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeInt(this.recordIds.size());
        for (Long recordId : this.recordIds) {
            out.writeLong(recordId);
        }
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        int size = in.readInt();
        this.recordIds = new ArrayList<Long>();
        for (int i = 0; i < size; ++i) {
            this.recordIds.add(in.readLong());
        }
    }

    @Override
    public int getId() {
        return 38;
    }
}

