/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.query.impl;

import com.hazelcast.nio.serialization.Data;
import com.hazelcast.query.impl.ComparisonType;
import com.hazelcast.query.impl.IndexImpl;
import com.hazelcast.query.impl.IndexStore;
import com.hazelcast.query.impl.MultiResultSet;
import com.hazelcast.query.impl.QueryableEntry;
import com.hazelcast.query.impl.SingleResultSet;
import java.util.NavigableSet;
import java.util.Set;
import java.util.SortedSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ConcurrentSkipListSet;

public class SortedIndexStore
implements IndexStore {
    private static final float LOAD_FACTOR = 0.75f;
    private final ConcurrentMap<Comparable, ConcurrentMap<Data, QueryableEntry>> mapRecords = new ConcurrentHashMap<Comparable, ConcurrentMap<Data, QueryableEntry>>(1000);
    private final NavigableSet<Comparable> sortedSet = new ConcurrentSkipListSet<Comparable>();

    @Override
    public void getSubRecordsBetween(MultiResultSet results, Comparable from, Comparable to) {
        SortedSet<Comparable> values = this.sortedSet.subSet(from, to);
        for (Comparable value : values) {
            ConcurrentMap records = (ConcurrentMap)this.mapRecords.get(value);
            if (records == null) continue;
            results.addResultSet(records);
        }
        ConcurrentMap records = (ConcurrentMap)this.mapRecords.get(to);
        if (records != null) {
            results.addResultSet(records);
        }
    }

    @Override
    public void getSubRecords(MultiResultSet results, ComparisonType comparisonType, Comparable searchedValue) {
        NavigableSet<Comparable> values;
        boolean notEqual = false;
        switch (comparisonType) {
            case LESSER: {
                values = this.sortedSet.headSet(searchedValue, false);
                break;
            }
            case LESSER_EQUAL: {
                values = this.sortedSet.headSet(searchedValue, true);
                break;
            }
            case GREATER: {
                values = this.sortedSet.tailSet(searchedValue, false);
                break;
            }
            case GREATER_EQUAL: {
                values = this.sortedSet.tailSet(searchedValue, true);
                break;
            }
            case NOT_EQUAL: {
                values = this.sortedSet;
                notEqual = true;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unrecognized comparisonType:" + (Object)((Object)comparisonType));
            }
        }
        for (Comparable value : values) {
            ConcurrentMap records;
            if (notEqual && searchedValue.equals(value) || (records = (ConcurrentMap)this.mapRecords.get(value)) == null) continue;
            results.addResultSet(records);
        }
    }

    @Override
    public void newIndex(Comparable newValue, QueryableEntry record) {
        ConcurrentHashMap<Data, QueryableEntry> records = (ConcurrentHashMap<Data, QueryableEntry>)this.mapRecords.get(newValue);
        if (records == null) {
            records = new ConcurrentHashMap<Data, QueryableEntry>(1, 0.75f, 1);
            this.mapRecords.put(newValue, records);
            if (!(newValue instanceof IndexImpl.NullObject)) {
                this.sortedSet.add(newValue);
            }
        }
        records.put(record.getIndexKey(), record);
    }

    @Override
    public ConcurrentMap<Data, QueryableEntry> getRecordMap(Comparable indexValue) {
        return (ConcurrentMap)this.mapRecords.get(indexValue);
    }

    @Override
    public void clear() {
        this.mapRecords.clear();
        this.sortedSet.clear();
    }

    @Override
    public void removeIndex(Comparable oldValue, Data indexKey) {
        ConcurrentMap records = (ConcurrentMap)this.mapRecords.get(oldValue);
        if (records != null) {
            records.remove(indexKey);
            if (records.size() == 0) {
                this.mapRecords.remove(oldValue);
                this.sortedSet.remove(oldValue);
            }
        }
    }

    @Override
    public Set<QueryableEntry> getRecords(Comparable value) {
        return new SingleResultSet((ConcurrentMap)this.mapRecords.get(value));
    }

    @Override
    public void getRecords(MultiResultSet results, Set<Comparable> values) {
        for (Comparable value : values) {
            ConcurrentMap records = (ConcurrentMap)this.mapRecords.get(value);
            if (records == null) continue;
            results.addResultSet(records);
        }
    }

    public String toString() {
        return "SortedIndexStore{mapRecords=" + this.mapRecords.size() + '}';
    }
}

