/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.queue.impl;

import com.hazelcast.core.ItemEventType;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.queue.impl.PollBackupOperation;
import com.hazelcast.queue.impl.QueueBackupAwareOperation;
import com.hazelcast.queue.impl.QueueDataSerializerHook;
import com.hazelcast.queue.impl.QueueItem;
import com.hazelcast.spi.Notifier;
import com.hazelcast.spi.Operation;
import com.hazelcast.spi.WaitNotifyKey;
import com.hazelcast.spi.WaitSupport;

public final class PollOperation
extends QueueBackupAwareOperation
implements WaitSupport,
Notifier,
IdentifiedDataSerializable {
    private QueueItem item;

    public PollOperation() {
    }

    public PollOperation(String name, long timeoutMillis) {
        super(name, timeoutMillis);
    }

    @Override
    public void run() {
        this.item = this.getOrCreateContainer().poll();
        if (this.item != null) {
            this.response = this.item.getData();
        }
    }

    @Override
    public void afterRun() throws Exception {
        if (this.response != null) {
            this.getQueueService().getLocalQueueStatsImpl(this.name).incrementPolls();
            this.publishEvent(ItemEventType.REMOVED, this.item.getData());
        } else {
            this.getQueueService().getLocalQueueStatsImpl(this.name).incrementEmptyPolls();
        }
    }

    @Override
    public boolean shouldBackup() {
        return this.response != null;
    }

    @Override
    public Operation getBackupOperation() {
        return new PollBackupOperation(this.name, this.item.getItemId());
    }

    @Override
    public boolean shouldNotify() {
        return this.response != null;
    }

    @Override
    public WaitNotifyKey getNotifiedKey() {
        return this.getOrCreateContainer().getOfferWaitNotifyKey();
    }

    @Override
    public WaitNotifyKey getWaitKey() {
        return this.getOrCreateContainer().getPollWaitNotifyKey();
    }

    @Override
    public boolean shouldWait() {
        return this.getWaitTimeout() != 0L && this.getOrCreateContainer().size() == 0;
    }

    @Override
    public void onWaitExpire() {
        this.getResponseHandler().sendResponse(null);
    }

    @Override
    public int getFactoryId() {
        return QueueDataSerializerHook.F_ID;
    }

    @Override
    public int getId() {
        return 1;
    }
}

