/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.nearcache;

import com.hazelcast.client.nearcache.ClientNearCache;
import com.hazelcast.client.spi.ClientContext;
import com.hazelcast.config.EvictionPolicy;
import com.hazelcast.config.InMemoryFormat;
import com.hazelcast.config.NearCacheConfig;
import com.hazelcast.monitor.impl.NearCacheStatsImpl;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.nio.serialization.SerializationService;
import com.hazelcast.util.Clock;
import com.hazelcast.util.ExceptionUtil;
import java.util.Comparator;
import java.util.Map;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;

public class ClientHeapNearCache<K>
implements ClientNearCache<K, Object> {
    private static final int SEC_TO_MILLISEC = 1000;
    private static final int HUNDRED_PERCENTAGE = 100;
    final int maxSize;
    final long maxIdleMillis;
    final long timeToLiveMillis;
    final boolean invalidateOnChange;
    final EvictionPolicy evictionPolicy;
    final InMemoryFormat inMemoryFormat;
    final String mapName;
    final ClientContext context;
    final AtomicBoolean canCleanUp;
    final AtomicBoolean canEvict;
    final ConcurrentMap<K, CacheRecord<K>> cache;
    final NearCacheStatsImpl stats;
    private volatile long lastCleanup;
    private volatile String id;
    private final Comparator<CacheRecord<K>> comparator = new Comparator<CacheRecord<K>>(){

        @Override
        public int compare(CacheRecord<K> o1, CacheRecord<K> o2) {
            if (EvictionPolicy.LRU.equals((Object)ClientHeapNearCache.this.evictionPolicy)) {
                return Long.valueOf(o1.lastAccessTime).compareTo(o2.lastAccessTime);
            }
            if (EvictionPolicy.LFU.equals((Object)ClientHeapNearCache.this.evictionPolicy)) {
                return Long.valueOf(o1.hit.get()).compareTo(o2.hit.get());
            }
            return 0;
        }
    };

    public ClientHeapNearCache(String mapName, ClientContext context, NearCacheConfig nearCacheConfig) {
        this.mapName = mapName;
        this.context = context;
        this.maxSize = nearCacheConfig.getMaxSize();
        this.maxIdleMillis = nearCacheConfig.getMaxIdleSeconds() * 1000;
        this.inMemoryFormat = nearCacheConfig.getInMemoryFormat();
        if (this.inMemoryFormat != InMemoryFormat.BINARY && this.inMemoryFormat != InMemoryFormat.OBJECT) {
            throw new IllegalArgumentException("Illegal in-memory-format: " + (Object)((Object)this.inMemoryFormat));
        }
        this.timeToLiveMillis = nearCacheConfig.getTimeToLiveSeconds() * 1000;
        this.invalidateOnChange = nearCacheConfig.isInvalidateOnChange();
        this.evictionPolicy = EvictionPolicy.valueOf(nearCacheConfig.getEvictionPolicy());
        this.cache = new ConcurrentHashMap<K, CacheRecord<K>>();
        this.canCleanUp = new AtomicBoolean(true);
        this.canEvict = new AtomicBoolean(true);
        this.lastCleanup = Clock.currentTimeMillis();
        this.stats = new NearCacheStatsImpl();
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void put(K key, Object object) {
        Object value;
        this.fireTtlCleanup();
        if (this.evictionPolicy == EvictionPolicy.NONE && this.cache.size() >= this.maxSize) {
            return;
        }
        if (this.evictionPolicy != EvictionPolicy.NONE && this.cache.size() >= this.maxSize) {
            this.fireEvictCache();
        }
        if (object == null) {
            value = NULL_OBJECT;
        } else {
            SerializationService serializationService = this.context.getSerializationService();
            if (this.inMemoryFormat == InMemoryFormat.BINARY) {
                value = serializationService.toData(object);
            } else if (this.inMemoryFormat == InMemoryFormat.OBJECT) {
                value = serializationService.toObject(object);
            } else {
                throw new IllegalArgumentException();
            }
        }
        this.cache.put(key, new CacheRecord<K>(key, value));
    }

    private void fireEvictCache() {
        if (this.canEvict.compareAndSet(true, false)) {
            try {
                this.context.getExecutionService().execute(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        try {
                            TreeSet records = new TreeSet(ClientHeapNearCache.this.comparator);
                            records.addAll(ClientHeapNearCache.this.cache.values());
                            int evictSize = ClientHeapNearCache.this.cache.size() * 20 / 100;
                            int i = 0;
                            for (CacheRecord record : records) {
                                ClientHeapNearCache.this.cache.remove(record.key);
                                if (++i <= evictSize) continue;
                                break;
                            }
                        }
                        finally {
                            ClientHeapNearCache.this.canEvict.set(true);
                        }
                    }
                });
            }
            catch (RejectedExecutionException e) {
                this.canEvict.set(true);
            }
            catch (Exception e) {
                throw ExceptionUtil.rethrow(e);
            }
        }
    }

    private void fireTtlCleanup() {
        if (Clock.currentTimeMillis() < this.lastCleanup + 5000L) {
            return;
        }
        if (this.canCleanUp.compareAndSet(true, false)) {
            try {
                this.context.getExecutionService().execute(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        try {
                            ClientHeapNearCache.this.lastCleanup = Clock.currentTimeMillis();
                            for (Map.Entry entry : ClientHeapNearCache.this.cache.entrySet()) {
                                if (!((CacheRecord)entry.getValue()).expired()) continue;
                                ClientHeapNearCache.this.cache.remove(entry.getKey());
                            }
                        }
                        finally {
                            ClientHeapNearCache.this.canCleanUp.set(true);
                        }
                    }
                });
            }
            catch (RejectedExecutionException e) {
                this.canCleanUp.set(true);
            }
            catch (Exception e) {
                throw ExceptionUtil.rethrow(e);
            }
        }
    }

    @Override
    public Object get(K key) {
        this.fireTtlCleanup();
        CacheRecord record = (CacheRecord)this.cache.get(key);
        if (record != null) {
            record.access();
            if (record.expired()) {
                this.cache.remove(key);
                this.stats.incrementMisses();
                return null;
            }
            if (record.value.equals(NULL_OBJECT)) {
                this.stats.incrementMisses();
                return NULL_OBJECT;
            }
            this.stats.incrementHits();
            return this.inMemoryFormat.equals((Object)InMemoryFormat.BINARY) ? this.context.getSerializationService().toObject(record.value) : record.value;
        }
        this.stats.incrementMisses();
        return null;
    }

    @Override
    public void remove(K key) {
        this.cache.remove(key);
    }

    @Override
    public void invalidate(K key) {
        this.cache.remove(key);
    }

    @Override
    public NearCacheStatsImpl getNearCacheStats() {
        long ownedEntryCount = 0L;
        long ownedEntryMemory = 0L;
        for (CacheRecord record : this.cache.values()) {
            ++ownedEntryCount;
            ownedEntryMemory += record.getCost();
        }
        this.stats.setOwnedEntryCount(ownedEntryCount);
        this.stats.setOwnedEntryMemoryCost(ownedEntryMemory);
        return this.stats;
    }

    @Override
    public void clear() {
        this.cache.clear();
    }

    @Override
    public void destroy() {
        this.cache.clear();
    }

    @Override
    public boolean isInvalidateOnChange() {
        return this.invalidateOnChange;
    }

    @Override
    public InMemoryFormat getInMemoryFormat() {
        return this.inMemoryFormat;
    }

    private class CacheRecord<K> {
        final K key;
        final Object value;
        final long creationTime;
        final AtomicLong hit;
        volatile long lastAccessTime;

        CacheRecord(K key, Object value) {
            long time;
            this.key = key;
            this.value = value;
            this.lastAccessTime = time = Clock.currentTimeMillis();
            this.creationTime = time;
            this.hit = new AtomicLong();
        }

        void access() {
            this.hit.incrementAndGet();
            this.lastAccessTime = Clock.currentTimeMillis();
        }

        public long getCost() {
            if (!(this.value instanceof Data)) {
                return 0L;
            }
            if (!(this.key instanceof Data)) {
                return 0L;
            }
            return ((Data)this.key).getHeapCost() + ((Data)this.value).getHeapCost() + 16 + 8 + 12;
        }

        boolean expired() {
            long time = Clock.currentTimeMillis();
            return ClientHeapNearCache.this.maxIdleMillis > 0L && time > this.lastAccessTime + ClientHeapNearCache.this.maxIdleMillis || ClientHeapNearCache.this.timeToLiveMillis > 0L && time > this.creationTime + ClientHeapNearCache.this.timeToLiveMillis;
        }
    }
}

