/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.spi.impl;

import com.hazelcast.client.impl.HazelcastClientInstanceImpl;
import com.hazelcast.client.spi.ClientClusterService;
import com.hazelcast.client.spi.ClientExecutionService;
import com.hazelcast.client.spi.ClientInvocationService;
import com.hazelcast.client.spi.ClientPartitionService;
import com.hazelcast.core.HazelcastInstanceNotActiveException;
import com.hazelcast.core.ICompletableFuture;
import com.hazelcast.core.Member;
import com.hazelcast.core.Partition;
import com.hazelcast.instance.MemberImpl;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import com.hazelcast.nio.Address;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.partition.client.GetPartitionsRequest;
import com.hazelcast.partition.client.PartitionsResponse;
import com.hazelcast.util.EmptyStatement;
import java.util.Collection;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

public final class ClientPartitionServiceImpl
implements ClientPartitionService {
    private static final ILogger LOGGER = Logger.getLogger(ClientPartitionService.class);
    private static final long PERIOD = 10L;
    private static final long INITIAL_DELAY = 10L;
    private final HazelcastClientInstanceImpl client;
    private final ConcurrentHashMap<Integer, Address> partitions = new ConcurrentHashMap(271, 0.75f, 1);
    private final AtomicBoolean updating = new AtomicBoolean(false);
    private volatile int partitionCount;

    public ClientPartitionServiceImpl(HazelcastClientInstanceImpl client) {
        this.client = client;
    }

    public void start() {
        this.getInitialPartitions();
        ClientExecutionService clientExecutionService = this.client.getClientExecutionService();
        clientExecutionService.scheduleWithFixedDelay(new RefreshTask(), 10L, 10L, TimeUnit.SECONDS);
    }

    public void refreshPartitions() {
        try {
            this.client.getClientExecutionService().execute(new RefreshTask());
        }
        catch (RejectedExecutionException ignored) {
            EmptyStatement.ignore(ignored);
        }
    }

    private void getInitialPartitions() {
        ClientClusterService clusterService = this.client.getClientClusterService();
        Collection<MemberImpl> memberList = clusterService.getMemberList();
        for (MemberImpl member : memberList) {
            Address target = member.getAddress();
            PartitionsResponse response = this.getPartitionsFrom(target);
            if (response == null) continue;
            this.processPartitionResponse(response);
            return;
        }
        throw new IllegalStateException("Cannot get initial partitions!");
    }

    private PartitionsResponse getPartitionsFrom(Address address) {
        try {
            ClientInvocationService invocationService = this.client.getInvocationService();
            ICompletableFuture future = invocationService.invokeOnTarget(new GetPartitionsRequest(), address);
            return (PartitionsResponse)this.client.getSerializationService().toObject(future.get());
        }
        catch (Exception e) {
            if (this.client.getLifecycleService().isRunning()) {
                LOGGER.severe("Error while fetching cluster partition table!", e);
            }
            return null;
        }
    }

    private void processPartitionResponse(PartitionsResponse response) {
        Address[] members = response.getMembers();
        int[] ownerIndexes = response.getOwnerIndexes();
        if (this.partitionCount == 0) {
            this.partitionCount = ownerIndexes.length;
        }
        for (int partitionId = 0; partitionId < this.partitionCount; ++partitionId) {
            int ownerIndex = ownerIndexes[partitionId];
            if (ownerIndex <= -1) continue;
            this.partitions.put(partitionId, members[ownerIndex]);
        }
    }

    public void stop() {
        this.partitions.clear();
    }

    @Override
    public Address getPartitionOwner(int partitionId) {
        return this.partitions.get(partitionId);
    }

    @Override
    public int getPartitionId(Data key) {
        int pc = this.partitionCount;
        if (pc <= 0) {
            return 0;
        }
        int hash = key.getPartitionHash();
        return hash == Integer.MIN_VALUE ? 0 : Math.abs(hash) % pc;
    }

    @Override
    public int getPartitionId(Object key) {
        Object data = this.client.getSerializationService().toData(key);
        return this.getPartitionId((Data)data);
    }

    @Override
    public int getPartitionCount() {
        return this.partitionCount;
    }

    @Override
    public Partition getPartition(int partitionId) {
        return new PartitionImpl(partitionId);
    }

    private class RefreshTask
    implements Runnable {
        private RefreshTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (!ClientPartitionServiceImpl.this.updating.compareAndSet(false, true)) {
                return;
            }
            try {
                ClientClusterService clusterService = ClientPartitionServiceImpl.this.client.getClientClusterService();
                Address master = clusterService.getMasterAddress();
                PartitionsResponse response = ClientPartitionServiceImpl.this.getPartitionsFrom(master);
                if (response != null) {
                    ClientPartitionServiceImpl.this.processPartitionResponse(response);
                }
            }
            catch (HazelcastInstanceNotActiveException ignored) {
                EmptyStatement.ignore(ignored);
            }
            finally {
                ClientPartitionServiceImpl.this.updating.set(false);
            }
        }
    }

    private final class PartitionImpl
    implements Partition {
        private final int partitionId;

        private PartitionImpl(int partitionId) {
            this.partitionId = partitionId;
        }

        @Override
        public int getPartitionId() {
            return this.partitionId;
        }

        @Override
        public Member getOwner() {
            Address owner = ClientPartitionServiceImpl.this.getPartitionOwner(this.partitionId);
            if (owner != null) {
                return ClientPartitionServiceImpl.this.client.getClientClusterService().getMember(owner);
            }
            return null;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("PartitionImpl{");
            sb.append("partitionId=").append(this.partitionId);
            sb.append('}');
            return sb.toString();
        }
    }
}

