/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.mapstore.writebehind;

import com.hazelcast.map.impl.mapstore.writebehind.ArrayWriteBehindQueue;
import com.hazelcast.map.impl.mapstore.writebehind.DelayedEntry;
import com.hazelcast.map.impl.mapstore.writebehind.ReachedMaxSizeException;
import com.hazelcast.map.impl.mapstore.writebehind.WriteBehindQueue;
import com.hazelcast.map.impl.mapstore.writebehind.WriteBehindQueues;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;

class BoundedArrayWriteBehindQueue
extends ArrayWriteBehindQueue {
    private final AtomicInteger writeBehindQueueItemCounter;
    private final int maxSize;

    BoundedArrayWriteBehindQueue(int maxSize, AtomicInteger writeBehindQueueItemCounter) {
        this.maxSize = maxSize;
        this.writeBehindQueueItemCounter = writeBehindQueueItemCounter;
    }

    BoundedArrayWriteBehindQueue(List<DelayedEntry> list, int maxSize, AtomicInteger writeBehindQueueItemCounter) {
        super(list);
        this.maxSize = maxSize;
        this.writeBehindQueueItemCounter = writeBehindQueueItemCounter;
    }

    @Override
    public boolean offer(DelayedEntry delayedEntry) {
        int currentPerNodeCount = this.currentPerNodeCount();
        if (this.hasReachedMaxSize(currentPerNodeCount)) {
            throw new ReachedMaxSizeException("Queue already reached per node max capacity [" + this.maxSize + "]");
        }
        this.incrementPerNodeMaxSize();
        return super.offer(delayedEntry);
    }

    @Override
    public void removeFirst() {
        super.removeFirst();
        this.decrementPerNodeMaxSize();
    }

    @Override
    public List<DelayedEntry> removeAll() {
        List<DelayedEntry> removes = super.removeAll();
        int size = removes.size();
        this.decrementPerNodeMaxSize(size);
        return removes;
    }

    @Override
    public void clear() {
        int size = this.size();
        super.clear();
        this.decrementPerNodeMaxSize(size);
    }

    @Override
    public WriteBehindQueue<DelayedEntry> getSnapShot() {
        if (this.list == null || this.list.isEmpty()) {
            return WriteBehindQueues.emptyWriteBehindQueue();
        }
        return new BoundedArrayWriteBehindQueue(new ArrayList<DelayedEntry>(this.list), this.maxSize, this.writeBehindQueueItemCounter);
    }

    @Override
    public void addFront(Collection<DelayedEntry> collection) {
        int size;
        if (collection == null || collection.isEmpty()) {
            return;
        }
        int currentPerNodeCount = this.currentPerNodeCount();
        int desiredSize = currentPerNodeCount + (size = collection.size());
        if (this.hasReachedMaxSize(desiredSize)) {
            throw new ReachedMaxSizeException("Remaining per node space is not enough for this collection. Remaining = [" + (this.maxSize - currentPerNodeCount) + "]");
        }
        this.incrementPerNodeMaxSize(size);
        super.addFront(collection);
    }

    @Override
    public void addEnd(Collection<DelayedEntry> collection) {
        int size;
        if (collection == null || collection.isEmpty()) {
            return;
        }
        int currentPerNodeCount = this.currentPerNodeCount();
        int desiredSize = currentPerNodeCount + (size = collection.size());
        if (this.hasReachedMaxSize(desiredSize)) {
            throw new ReachedMaxSizeException("Remaining per node space is not enough for this collection. Remaining = [" + (this.maxSize - currentPerNodeCount) + "]");
        }
        this.incrementPerNodeMaxSize(size);
        super.addEnd(collection);
    }

    @Override
    public void removeAll(Collection<DelayedEntry> collection) {
        if (collection == null || collection.isEmpty()) {
            return;
        }
        super.removeAll(collection);
        this.decrementPerNodeMaxSize(collection.size());
    }

    private boolean hasReachedMaxSize(int size) {
        return size >= this.maxSize;
    }

    private int currentPerNodeCount() {
        return this.writeBehindQueueItemCounter.intValue();
    }

    private void incrementPerNodeMaxSize() {
        this.writeBehindQueueItemCounter.incrementAndGet();
    }

    private void incrementPerNodeMaxSize(int count) {
        this.writeBehindQueueItemCounter.addAndGet(count);
    }

    private void decrementPerNodeMaxSize() {
        this.writeBehindQueueItemCounter.decrementAndGet();
    }

    private void decrementPerNodeMaxSize(int size) {
        this.writeBehindQueueItemCounter.addAndGet(-size);
    }
}

