/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.mapstore.writebehind;

import com.hazelcast.map.impl.mapstore.writebehind.AbstractDelayedEntry;

public final class DelayedEntry<K, V>
extends AbstractDelayedEntry<K> {
    private final V value;

    private DelayedEntry(K key, V value, long storeTime, int partitionId) {
        super(key, storeTime, partitionId);
        this.value = value;
    }

    public V getValue() {
        return this.value;
    }

    public static <K, V> DelayedEntry<K, V> create(K key, V value, long storeTime, int partitionId) {
        return new DelayedEntry<K, V>(key, value, storeTime, partitionId);
    }

    public static <K, V> DelayedEntry<K, V> create(K key, V value, long storeTime) {
        return new DelayedEntry<K, V>(key, value, storeTime, -1);
    }

    public static <K, V> DelayedEntry<K, V> createWithNullKey(V value, long storeTime) {
        return new DelayedEntry<Object, V>(null, value, storeTime, 0);
    }

    public static <K, V> DelayedEntry<K, V> createWithNullValue(K key, long storeTime, int partitionId) {
        return new DelayedEntry<K, Object>(key, null, storeTime, partitionId);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public boolean equals(Object o) {
        return super.equals(o);
    }

    public String toString() {
        return "DelayedEntry{key=" + this.key + ", value=" + this.value + ", storeTime=" + this.storeTime + ", partitionId=" + this.getPartitionId() + '}';
    }
}

