/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.mapreduce.impl.task;

import com.hazelcast.mapreduce.JobPartitionState;
import com.hazelcast.mapreduce.JobProcessInformation;
import com.hazelcast.mapreduce.impl.MapReducePortableHook;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.Portable;
import com.hazelcast.nio.serialization.PortableReader;
import com.hazelcast.nio.serialization.PortableWriter;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.IOException;

public class TransferableJobProcessInformation
implements JobProcessInformation,
Portable {
    private JobPartitionState[] partitionStates;
    private int processedRecords;

    public TransferableJobProcessInformation() {
    }

    public TransferableJobProcessInformation(JobPartitionState[] partitionStates, int processedRecords) {
        this.partitionStates = new JobPartitionState[partitionStates.length];
        System.arraycopy(partitionStates, 0, this.partitionStates, 0, partitionStates.length);
        this.processedRecords = processedRecords;
    }

    @Override
    @SuppressWarnings(value={"EI_EXPOSE_REP"})
    public JobPartitionState[] getPartitionStates() {
        return this.partitionStates;
    }

    @Override
    public int getProcessedRecords() {
        return this.processedRecords;
    }

    @Override
    public void writePortable(PortableWriter writer) throws IOException {
        writer.writeInt("processedRecords", this.processedRecords);
        ObjectDataOutput out = writer.getRawDataOutput();
        out.writeObject(this.partitionStates);
    }

    @Override
    public void readPortable(PortableReader reader) throws IOException {
        this.processedRecords = reader.readInt("processedRecords");
        ObjectDataInput in = reader.getRawDataInput();
        this.partitionStates = (JobPartitionState[])in.readObject();
    }

    @Override
    public int getFactoryId() {
        return MapReducePortableHook.F_ID;
    }

    @Override
    public int getClassId() {
        return 4;
    }
}

