/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.nio.serialization;

import com.hazelcast.nio.Bits;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.nio.serialization.MutableData;
import com.hazelcast.util.HashUtil;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.nio.ByteOrder;

@SuppressWarnings(value={"EI_EXPOSE_REP"})
public final class DefaultData
implements MutableData {
    private int type = 0;
    private byte[] header;
    private byte[] data;
    private int partitionHash;

    public DefaultData() {
    }

    public DefaultData(int type, byte[] data) {
        this.data = data;
        this.type = type;
    }

    public DefaultData(int type, byte[] data, int partitionHash) {
        this.data = data;
        this.partitionHash = partitionHash;
        this.type = type;
    }

    public DefaultData(int type, byte[] data, int partitionHash, byte[] header) {
        this.type = type;
        this.data = data;
        this.partitionHash = partitionHash;
        this.header = header;
    }

    @Override
    public int dataSize() {
        return this.data != null ? this.data.length : 0;
    }

    @Override
    public int getPartitionHash() {
        return this.partitionHash != 0 ? this.partitionHash : this.hashCode();
    }

    @Override
    public boolean hasPartitionHash() {
        return this.partitionHash != 0;
    }

    @Override
    public int headerSize() {
        return this.header != null ? this.header.length : 0;
    }

    @Override
    public byte[] getHeader() {
        return this.header;
    }

    @Override
    public byte[] getData() {
        return this.data;
    }

    @Override
    public void setData(byte[] array) {
        this.data = array;
    }

    @Override
    public void setPartitionHash(int partitionHash) {
        this.partitionHash = partitionHash;
    }

    @Override
    public int getType() {
        return this.type;
    }

    @Override
    public void setType(int type) {
        this.type = type;
    }

    @Override
    public void setHeader(byte[] header) {
        this.header = header;
    }

    @Override
    public int readIntHeader(int offset, ByteOrder order) {
        return Bits.readInt(this.header, offset, order == ByteOrder.BIG_ENDIAN);
    }

    @Override
    public int getHeapCost() {
        int integerSizeInBytes = 4;
        int arrayHeaderSizeInBytes = 16;
        int total = 0;
        total += 4;
        if (this.header != null) {
            total += 16;
            total += this.header.length;
        } else {
            total += 4;
        }
        if (this.data != null) {
            total += 16;
            total += this.data.length;
        } else {
            total += 4;
        }
        return total += 4;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (!(o instanceof Data)) {
            return false;
        }
        Data data = (Data)o;
        if (this.getType() != data.getType()) {
            return false;
        }
        int dataSize = this.dataSize();
        if (dataSize != data.dataSize()) {
            return false;
        }
        return dataSize == 0 || DefaultData.equals(this.data, data.getData());
    }

    private static boolean equals(byte[] data1, byte[] data2) {
        if (data1 == data2) {
            return true;
        }
        if (data1 == null || data2 == null) {
            return false;
        }
        int length = data1.length;
        if (data2.length != length) {
            return false;
        }
        for (int i = length - 1; i >= 0; --i) {
            if (data1[i] == data2[i]) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        return HashUtil.MurmurHash3_x86_32(this.data, 0, this.dataSize());
    }

    @Override
    public long hash64() {
        return HashUtil.MurmurHash3_x64_64(this.data, 0, this.dataSize());
    }

    @Override
    public boolean isPortable() {
        return -1 == this.type;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("HeapData{");
        sb.append("type=").append(this.getType());
        sb.append(", hashCode=").append(this.hashCode());
        sb.append(", partitionHash=").append(this.getPartitionHash());
        sb.append(", dataSize=").append(this.dataSize());
        sb.append(", heapCost=").append(this.getHeapCost());
        sb.append('}');
        return sb.toString();
    }
}

