/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.web;

import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.query.Predicate;
import com.hazelcast.web.WebDataSerializerHook;
import java.io.IOException;
import java.util.Map;

public class SessionAttributePredicate
implements Predicate,
IdentifiedDataSerializable {
    private String sessionId;

    public SessionAttributePredicate() {
    }

    public SessionAttributePredicate(String sessionId) {
        this.sessionId = sessionId;
    }

    public boolean apply(Map.Entry mapEntry) {
        Object key = mapEntry.getKey();
        if (key instanceof String) {
            String k = (String)key;
            return k.startsWith(this.sessionId + "::hz::");
        }
        return false;
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeUTF(this.sessionId);
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        this.sessionId = in.readUTF();
    }

    @Override
    public int getFactoryId() {
        return WebDataSerializerHook.F_ID;
    }

    @Override
    public int getId() {
        return 1;
    }
}

