/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.cache.impl.client;

import com.hazelcast.cache.impl.client.CacheInvalidationMessage;
import com.hazelcast.cache.impl.client.CacheSingleInvalidationMessage;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.PortableReader;
import com.hazelcast.nio.serialization.PortableWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class CacheBatchInvalidationMessage
extends CacheInvalidationMessage {
    private List<CacheSingleInvalidationMessage> invalidationMessages;

    public CacheBatchInvalidationMessage() {
    }

    public CacheBatchInvalidationMessage(String name) {
        super(name);
        this.invalidationMessages = new ArrayList<CacheSingleInvalidationMessage>();
    }

    public CacheBatchInvalidationMessage(String name, int expectedMessageCount) {
        super(name);
        this.invalidationMessages = new ArrayList<CacheSingleInvalidationMessage>(expectedMessageCount);
    }

    public CacheBatchInvalidationMessage(String name, List<CacheSingleInvalidationMessage> invalidationMessages) {
        super(name);
        this.invalidationMessages = invalidationMessages;
    }

    public CacheBatchInvalidationMessage addInvalidationMessage(CacheSingleInvalidationMessage invalidationMessage) {
        this.invalidationMessages.add(invalidationMessage);
        return this;
    }

    public List<CacheSingleInvalidationMessage> getInvalidationMessages() {
        return this.invalidationMessages;
    }

    @Override
    public int getClassId() {
        return 15;
    }

    @Override
    public void writePortable(PortableWriter writer) throws IOException {
        super.writePortable(writer);
        ObjectDataOutput out = writer.getRawDataOutput();
        boolean hasInvalidationMessages = this.invalidationMessages != null;
        out.writeBoolean(hasInvalidationMessages);
        if (hasInvalidationMessages) {
            out.writeInt(this.invalidationMessages.size());
            for (CacheSingleInvalidationMessage invalidationMessage : this.invalidationMessages) {
                out.writeObject(invalidationMessage);
            }
        }
    }

    @Override
    public void readPortable(PortableReader reader) throws IOException {
        super.readPortable(reader);
        ObjectDataInput in = reader.getRawDataInput();
        if (in.readBoolean()) {
            int size = in.readInt();
            this.invalidationMessages = new ArrayList<CacheSingleInvalidationMessage>(size);
            for (int i = 0; i < size; ++i) {
                this.invalidationMessages.add((CacheSingleInvalidationMessage)in.readObject());
            }
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("CacheBatchInvalidationMessage{");
        sb.append("name='").append(this.name).append('\'');
        sb.append(", invalidationMessages=").append(this.invalidationMessages);
        sb.append('}');
        return sb.toString();
    }
}

