/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.protocol.task.map;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.task.AbstractCallableMessageTask;
import com.hazelcast.instance.MemberImpl;
import com.hazelcast.instance.Node;
import com.hazelcast.map.impl.QueryResult;
import com.hazelcast.map.impl.operation.QueryOperation;
import com.hazelcast.map.impl.operation.QueryPartitionOperation;
import com.hazelcast.nio.Connection;
import com.hazelcast.query.Predicate;
import com.hazelcast.query.impl.QueryResultEntry;
import com.hazelcast.security.permission.MapPermission;
import com.hazelcast.spi.InternalCompletableFuture;
import com.hazelcast.spi.Operation;
import com.hazelcast.spi.impl.operationservice.InternalOperationService;
import com.hazelcast.util.ExceptionUtil;
import java.security.Permission;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

public abstract class AbstractMapQueryMessageTask<P>
extends AbstractCallableMessageTask<P> {
    protected AbstractMapQueryMessageTask(ClientMessage clientMessage, Node node, Connection connection) {
        super(clientMessage, node, connection);
    }

    @Override
    public final String getServiceName() {
        return "hz:impl:mapService";
    }

    @Override
    public Permission getRequiredPermission() {
        return new MapPermission(this.getDistributedObjectName(), "read");
    }

    @Override
    protected final Object call() throws Exception {
        LinkedList<QueryResultEntry> result = new LinkedList<QueryResultEntry>();
        Collection<MemberImpl> members = this.nodeEngine.getClusterService().getMemberList();
        ArrayList<Future> futures = new ArrayList<Future>();
        Predicate predicate = this.getPredicate();
        this.createInvocations(members, futures, predicate);
        int partitionCount = this.nodeEngine.getPartitionService().getPartitionCount();
        HashSet<Integer> finishedPartitions = new HashSet<Integer>(partitionCount);
        this.collectResults(result, futures, finishedPartitions);
        if (this.hasMissingPartitions(finishedPartitions, partitionCount)) {
            List<Integer> missingList = this.findMissingPartitions(finishedPartitions, partitionCount);
            ArrayList<Future> missingFutures = new ArrayList<Future>(missingList.size());
            this.createInvocationsForMissingPartitions(missingList, missingFutures, predicate);
            this.collectResultsFromMissingPartitions(result, missingFutures);
        }
        return this.reduce(result);
    }

    protected abstract Predicate getPredicate();

    protected abstract Object reduce(Collection<QueryResultEntry> var1);

    private void createInvocations(Collection<MemberImpl> members, List<Future> futures, Predicate predicate) {
        InternalOperationService operationService = this.nodeEngine.getOperationService();
        for (MemberImpl member : members) {
            InternalCompletableFuture future = operationService.createInvocationBuilder("hz:impl:mapService", (Operation)new QueryOperation(this.getDistributedObjectName(), predicate), member.getAddress()).invoke();
            futures.add(future);
        }
    }

    private void collectResults(Collection<QueryResultEntry> result, List<Future> futures, Set<Integer> finishedPartitions) throws InterruptedException, ExecutionException {
        for (Future future : futures) {
            Collection<Integer> partitionIds;
            QueryResult queryResult = (QueryResult)future.get();
            if (queryResult == null || (partitionIds = queryResult.getPartitionIds()) == null) continue;
            finishedPartitions.addAll(partitionIds);
            result.addAll(queryResult.getResult());
        }
    }

    private boolean hasMissingPartitions(Set<Integer> finishedPartitions, int partitionCount) {
        return finishedPartitions.size() != partitionCount;
    }

    private List<Integer> findMissingPartitions(Set<Integer> finishedPartitions, int partitionCount) {
        ArrayList<Integer> missingList = new ArrayList<Integer>();
        for (int i = 0; i < partitionCount; ++i) {
            if (finishedPartitions.contains(i)) continue;
            missingList.add(i);
        }
        return missingList;
    }

    private void createInvocationsForMissingPartitions(List<Integer> missingPartitionsList, List<Future> futures, Predicate predicate) {
        InternalOperationService operationService = this.nodeEngine.getOperationService();
        for (Integer partitionId : missingPartitionsList) {
            QueryPartitionOperation queryPartitionOperation = new QueryPartitionOperation(this.getDistributedObjectName(), predicate);
            queryPartitionOperation.setPartitionId(partitionId);
            try {
                InternalCompletableFuture future = operationService.invokeOnPartition("hz:impl:mapService", queryPartitionOperation, partitionId);
                futures.add(future);
            }
            catch (Throwable t) {
                throw ExceptionUtil.rethrow(t);
            }
        }
    }

    private void collectResultsFromMissingPartitions(Collection<QueryResultEntry> result, List<Future> futures) throws InterruptedException, ExecutionException {
        for (Future future : futures) {
            QueryResult queryResult = (QueryResult)future.get();
            result.addAll(queryResult.getResult());
        }
    }
}

