/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.client;

import com.hazelcast.client.impl.client.AllPartitionsClientRequest;
import com.hazelcast.client.impl.client.RetryableRequest;
import com.hazelcast.client.impl.client.SecureRequest;
import com.hazelcast.map.impl.MapEntrySet;
import com.hazelcast.map.impl.MapPortableHook;
import com.hazelcast.map.impl.MapService;
import com.hazelcast.map.impl.operation.EntrySetOperationFactory;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.nio.serialization.Portable;
import com.hazelcast.nio.serialization.PortableReader;
import com.hazelcast.nio.serialization.PortableWriter;
import com.hazelcast.security.permission.MapPermission;
import com.hazelcast.spi.OperationFactory;
import java.io.IOException;
import java.security.Permission;
import java.util.HashSet;
import java.util.Map;

public class MapEntrySetRequest
extends AllPartitionsClientRequest
implements Portable,
RetryableRequest,
SecureRequest {
    private String name;

    public MapEntrySetRequest() {
    }

    public MapEntrySetRequest(String name) {
        this.name = name;
    }

    @Override
    protected OperationFactory createOperationFactory() {
        return new EntrySetOperationFactory(this.name);
    }

    @Override
    protected Object reduce(Map<Integer, Object> map) {
        HashSet<Map.Entry<Data, Data>> entrySet = new HashSet<Map.Entry<Data, Data>>();
        MapService service = (MapService)this.getService();
        for (Object result : map.values()) {
            entrySet.addAll(((MapEntrySet)service.getMapServiceContext().toObject(result)).getEntrySet());
        }
        return new MapEntrySet(entrySet);
    }

    @Override
    public String getServiceName() {
        return "hz:impl:mapService";
    }

    @Override
    public int getFactoryId() {
        return MapPortableHook.F_ID;
    }

    @Override
    public int getClassId() {
        return 31;
    }

    @Override
    public void write(PortableWriter writer) throws IOException {
        writer.writeUTF("n", this.name);
    }

    @Override
    public void read(PortableReader reader) throws IOException {
        this.name = reader.readUTF("n");
    }

    @Override
    public Permission getRequiredPermission() {
        return new MapPermission(this.name, "read");
    }

    @Override
    public String getDistributedObjectName() {
        return this.name;
    }

    @Override
    public String getMethodName() {
        return "entrySet";
    }
}

