/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.operation;

import com.hazelcast.core.EntryEventType;
import com.hazelcast.core.EntryView;
import com.hazelcast.map.impl.MapEventPublisher;
import com.hazelcast.map.impl.MapServiceContext;
import com.hazelcast.map.impl.operation.BasePutOperation;
import com.hazelcast.map.impl.operation.PutBackupOperation;
import com.hazelcast.map.impl.operation.RemoveBackupOperation;
import com.hazelcast.map.impl.record.Record;
import com.hazelcast.map.impl.record.RecordInfo;
import com.hazelcast.map.impl.record.Records;
import com.hazelcast.map.merge.MapMergePolicy;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.spi.Operation;
import java.io.IOException;

public class MergeOperation
extends BasePutOperation {
    private MapMergePolicy mergePolicy;
    private EntryView<Data, Data> mergingEntry;
    private boolean merged;
    private Data mergingValue;

    public MergeOperation(String name, Data dataKey, EntryView<Data, Data> entryView, MapMergePolicy policy) {
        super(name, dataKey, null);
        this.mergingEntry = entryView;
        this.mergePolicy = policy;
    }

    public MergeOperation() {
    }

    @Override
    public void run() {
        Record record;
        Record oldRecord = this.recordStore.getRecord(this.dataKey);
        if (oldRecord != null) {
            this.dataOldValue = this.mapService.getMapServiceContext().toData(oldRecord.getValue());
        }
        this.merged = this.recordStore.merge(this.dataKey, this.mergingEntry, this.mergePolicy);
        if (this.merged && (record = this.recordStore.getRecord(this.dataKey)) != null) {
            MapServiceContext mapServiceContext = this.mapService.getMapServiceContext();
            this.dataValue = mapServiceContext.toData(record.getValue());
            this.mergingValue = this.mapService.getMapServiceContext().toData(this.mergingEntry.getValue());
        }
    }

    @Override
    public Object getResponse() {
        return this.merged;
    }

    @Override
    public boolean shouldBackup() {
        Record record = this.recordStore.getRecord(this.dataKey);
        return this.merged && record != null;
    }

    @Override
    public void afterRun() {
        if (this.merged) {
            MapServiceContext mapServiceContext = this.mapService.getMapServiceContext();
            MapEventPublisher mapEventPublisher = mapServiceContext.getMapEventPublisher();
            mapServiceContext.interceptAfterPut(this.name, this.dataValue);
            mapEventPublisher.publishEvent(this.getCallerAddress(), this.name, EntryEventType.MERGED, false, this.dataKey, this.dataOldValue, this.dataValue, this.mergingValue);
            this.invalidateNearCaches();
            this.evict(false);
        }
    }

    @Override
    public Operation getBackupOperation() {
        if (this.dataValue == null) {
            return new RemoveBackupOperation(this.name, this.dataKey);
        }
        Record record = this.recordStore.getRecord(this.dataKey);
        RecordInfo replicationInfo = record != null ? Records.buildRecordInfo(record) : null;
        return new PutBackupOperation(this.name, this.dataKey, this.dataValue, replicationInfo);
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeObject(this.mergingEntry);
        out.writeObject(this.mergePolicy);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.mergingEntry = (EntryView)in.readObject();
        this.mergePolicy = (MapMergePolicy)in.readObject();
    }

    @Override
    public String toString() {
        return "MergeOperation{" + this.name + "}";
    }
}

