/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.cache.impl;

import com.hazelcast.cache.impl.CacheContext;
import com.hazelcast.cache.impl.CacheDistributedObject;
import com.hazelcast.cache.impl.CacheEntryCountResolver;
import com.hazelcast.cache.impl.CacheEntryListenerProvider;
import com.hazelcast.cache.impl.CacheEventContext;
import com.hazelcast.cache.impl.CacheEventHandler;
import com.hazelcast.cache.impl.CacheEventListener;
import com.hazelcast.cache.impl.CacheEventSet;
import com.hazelcast.cache.impl.CacheMXBeanImpl;
import com.hazelcast.cache.impl.CacheOperationProvider;
import com.hazelcast.cache.impl.CachePartitionEventData;
import com.hazelcast.cache.impl.CachePartitionSegment;
import com.hazelcast.cache.impl.CacheSplitBrainHandler;
import com.hazelcast.cache.impl.CacheStatisticsImpl;
import com.hazelcast.cache.impl.CacheStatisticsMXBeanImpl;
import com.hazelcast.cache.impl.ICacheRecordStore;
import com.hazelcast.cache.impl.ICacheService;
import com.hazelcast.cache.impl.MXBeanUtil;
import com.hazelcast.cache.impl.event.CachePartitionLostEventFilter;
import com.hazelcast.cache.impl.operation.CacheDestroyOperation;
import com.hazelcast.cache.impl.operation.PostJoinCacheOperation;
import com.hazelcast.config.CacheConfig;
import com.hazelcast.config.CacheSimpleConfig;
import com.hazelcast.config.InMemoryFormat;
import com.hazelcast.core.DistributedObject;
import com.hazelcast.core.Member;
import com.hazelcast.nio.IOUtil;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.partition.InternalPartitionLostEvent;
import com.hazelcast.partition.MigrationEndpoint;
import com.hazelcast.spi.EventFilter;
import com.hazelcast.spi.EventRegistration;
import com.hazelcast.spi.EventService;
import com.hazelcast.spi.NodeEngine;
import com.hazelcast.spi.Operation;
import com.hazelcast.spi.OperationService;
import com.hazelcast.spi.PartitionAwareService;
import com.hazelcast.spi.PartitionMigrationEvent;
import com.hazelcast.spi.PostJoinAwareService;
import com.hazelcast.spi.QuorumAwareService;
import com.hazelcast.spi.SplitBrainHandlerService;
import com.hazelcast.util.Clock;
import com.hazelcast.util.ConcurrencyUtil;
import com.hazelcast.util.ConstructorFunction;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.Closeable;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.cache.configuration.CacheEntryListenerConfiguration;
import javax.cache.event.CacheEntryListener;

public abstract class AbstractCacheService
implements ICacheService,
PostJoinAwareService,
PartitionAwareService,
QuorumAwareService,
SplitBrainHandlerService {
    protected final ConcurrentMap<String, CacheConfig> configs = new ConcurrentHashMap<String, CacheConfig>();
    protected final ConcurrentMap<String, CacheContext> cacheContexts = new ConcurrentHashMap<String, CacheContext>();
    protected final ConcurrentMap<String, CacheStatisticsImpl> statistics = new ConcurrentHashMap<String, CacheStatisticsImpl>();
    protected final ConcurrentMap<String, Set<Closeable>> resources = new ConcurrentHashMap<String, Set<Closeable>>();
    protected final ConcurrentMap<String, Closeable> closeableListeners = new ConcurrentHashMap<String, Closeable>();
    protected final ConcurrentMap<String, CacheOperationProvider> operationProviderCache = new ConcurrentHashMap<String, CacheOperationProvider>();
    protected final ConstructorFunction<String, CacheContext> cacheContexesConstructorFunction = new ConstructorFunction<String, CacheContext>(){

        @Override
        public CacheContext createNew(String name) {
            return new CacheContext();
        }
    };
    protected final ConstructorFunction<String, CacheStatisticsImpl> cacheStatisticsConstructorFunction = new ConstructorFunction<String, CacheStatisticsImpl>(){

        @Override
        public CacheStatisticsImpl createNew(String name) {
            return new CacheStatisticsImpl(Clock.currentTimeMillis(), CacheEntryCountResolver.createEntryCountResolver(AbstractCacheService.this.getOrCreateCacheContext(name)));
        }
    };
    protected NodeEngine nodeEngine;
    protected CachePartitionSegment[] segments;
    protected CacheEventHandler cacheEventHandler;
    protected CacheSplitBrainHandler cacheSplitBrainHandler;

    @Override
    public final void init(NodeEngine nodeEngine, Properties properties) {
        this.nodeEngine = nodeEngine;
        int partitionCount = nodeEngine.getPartitionService().getPartitionCount();
        this.segments = new CachePartitionSegment[partitionCount];
        for (int i = 0; i < partitionCount; ++i) {
            this.segments[i] = this.newPartitionSegment(i);
        }
        this.cacheEventHandler = new CacheEventHandler(nodeEngine);
        this.cacheSplitBrainHandler = new CacheSplitBrainHandler(nodeEngine, this.configs, this.segments);
        this.postInit(nodeEngine, properties);
    }

    protected void postInit(NodeEngine nodeEngine, Properties properties) {
    }

    protected abstract CachePartitionSegment newPartitionSegment(int var1);

    protected abstract ICacheRecordStore createNewRecordStore(String var1, int var2);

    @Override
    public void reset() {
        this.reset(false);
    }

    private void reset(boolean onShutdown) {
        CachePartitionSegment[] partitionSegments;
        for (String objectName : this.configs.keySet()) {
            this.deleteCache(objectName, true, null, false);
        }
        for (CachePartitionSegment partitionSegment : partitionSegments = this.segments) {
            if (partitionSegment == null) continue;
            if (onShutdown) {
                partitionSegment.shutdown();
                continue;
            }
            partitionSegment.clear();
            partitionSegment.init();
        }
    }

    @Override
    public void shutdown(boolean terminate) {
        if (!terminate) {
            this.cacheEventHandler.shutdown();
            this.reset(true);
        }
    }

    @Override
    public DistributedObject createDistributedObject(String objectName) {
        return new CacheDistributedObject(objectName, this.nodeEngine, this);
    }

    @Override
    public void destroyDistributedObject(String objectName) {
    }

    @Override
    public void beforeMigration(PartitionMigrationEvent event) {
    }

    @Override
    public void commitMigration(PartitionMigrationEvent event) {
        if (event.getMigrationEndpoint() == MigrationEndpoint.SOURCE) {
            this.clearPartitionReplica(event.getPartitionId());
        }
        this.initPartitionReplica(event.getPartitionId());
    }

    @Override
    public void rollbackMigration(PartitionMigrationEvent event) {
        if (event.getMigrationEndpoint() == MigrationEndpoint.DESTINATION) {
            this.clearPartitionReplica(event.getPartitionId());
        }
        this.initPartitionReplica(event.getPartitionId());
    }

    private void initPartitionReplica(int partitionId) {
        this.segments[partitionId].init();
    }

    @Override
    public void clearPartitionReplica(int partitionId) {
        this.segments[partitionId].clear();
    }

    @Override
    public ICacheRecordStore getOrCreateRecordStore(String name, int partitionId) {
        return this.segments[partitionId].getOrCreateRecordStore(name);
    }

    @Override
    public ICacheRecordStore getRecordStore(String name, int partitionId) {
        return this.segments[partitionId].getRecordStore(name);
    }

    @Override
    public CachePartitionSegment getSegment(int partitionId) {
        return this.segments[partitionId];
    }

    protected void destroySegments(String name) {
        for (CachePartitionSegment segment : this.segments) {
            segment.deleteRecordStore(name, true);
        }
    }

    protected void closeSegments(String name) {
        for (CachePartitionSegment segment : this.segments) {
            segment.deleteRecordStore(name, false);
        }
    }

    @Override
    public void deleteCache(String name, boolean isLocal, String callerUuid, boolean destroy) {
        CacheConfig config = this.deleteCacheConfig(name);
        if (destroy) {
            this.destroySegments(name);
        } else {
            this.closeSegments(name);
        }
        if (!isLocal) {
            this.deregisterAllListener(name);
            this.cacheContexts.remove(name);
        }
        this.operationProviderCache.remove(name);
        this.setStatisticsEnabled(config, name, false);
        this.setManagementEnabled(config, name, false);
        this.deleteCacheConfig(name);
        this.deleteCacheStat(name);
        this.deleteCacheResources(name);
        if (!isLocal) {
            this.destroyCacheOnAllMembers(name, callerUuid);
        }
    }

    protected void destroyCacheOnAllMembers(String name, String callerUuid) {
        OperationService operationService = this.nodeEngine.getOperationService();
        Set<Member> members = this.nodeEngine.getClusterService().getMembers();
        for (Member member : members) {
            if (member.localMember() || member.getUuid().equals(callerUuid)) continue;
            CacheDestroyOperation op = new CacheDestroyOperation(name, true);
            operationService.invokeOnTarget("hz:impl:cacheService", op, member.getAddress());
        }
    }

    @Override
    public CacheConfig putCacheConfigIfAbsent(CacheConfig config) {
        CacheConfig localConfig = this.configs.putIfAbsent(config.getNameWithPrefix(), config);
        if (localConfig == null) {
            if (config.isStatisticsEnabled()) {
                this.setStatisticsEnabled(config, config.getNameWithPrefix(), true);
            }
            if (config.isManagementEnabled()) {
                this.setManagementEnabled(config, config.getNameWithPrefix(), true);
            }
        }
        return localConfig;
    }

    @Override
    public CacheConfig deleteCacheConfig(String name) {
        return (CacheConfig)this.configs.remove(name);
    }

    @Override
    public CacheStatisticsImpl createCacheStatIfAbsent(String name) {
        return ConcurrencyUtil.getOrPutIfAbsent(this.statistics, name, this.cacheStatisticsConstructorFunction);
    }

    public CacheContext getCacheContext(String name) {
        return (CacheContext)this.cacheContexts.get(name);
    }

    @Override
    public CacheContext getOrCreateCacheContext(String name) {
        return ConcurrencyUtil.getOrPutIfAbsent(this.cacheContexts, name, this.cacheContexesConstructorFunction);
    }

    @Override
    public void deleteCacheStat(String name) {
        this.statistics.remove(name);
    }

    @Override
    public void setStatisticsEnabled(CacheConfig cacheConfig, String cacheNameWithPrefix, boolean enabled) {
        CacheConfig cacheConfig2 = cacheConfig = cacheConfig != null ? cacheConfig : (CacheConfig)this.configs.get(cacheNameWithPrefix);
        if (cacheConfig != null) {
            String cacheManagerName = cacheConfig.getUriString();
            cacheConfig.setStatisticsEnabled(enabled);
            if (enabled) {
                CacheStatisticsImpl cacheStatistics = this.createCacheStatIfAbsent(cacheNameWithPrefix);
                CacheStatisticsMXBeanImpl mxBean = new CacheStatisticsMXBeanImpl(cacheStatistics);
                MXBeanUtil.registerCacheObject(mxBean, cacheManagerName, cacheConfig.getName(), true);
            } else {
                MXBeanUtil.unregisterCacheObject(cacheManagerName, cacheConfig.getName(), true);
                this.deleteCacheStat(cacheNameWithPrefix);
            }
        }
    }

    @Override
    public void setManagementEnabled(CacheConfig cacheConfig, String cacheNameWithPrefix, boolean enabled) {
        CacheConfig cacheConfig2 = cacheConfig = cacheConfig != null ? cacheConfig : (CacheConfig)this.configs.get(cacheNameWithPrefix);
        if (cacheConfig != null) {
            String cacheManagerName = cacheConfig.getUriString();
            cacheConfig.setManagementEnabled(enabled);
            if (enabled) {
                CacheMXBeanImpl mxBean = new CacheMXBeanImpl(cacheConfig);
                MXBeanUtil.registerCacheObject(mxBean, cacheManagerName, cacheConfig.getName(), false);
            } else {
                MXBeanUtil.unregisterCacheObject(cacheManagerName, cacheConfig.getName(), false);
                this.deleteCacheStat(cacheNameWithPrefix);
            }
        }
    }

    @Override
    public CacheConfig getCacheConfig(String name) {
        return (CacheConfig)this.configs.get(name);
    }

    @Override
    public CacheSimpleConfig findCacheConfig(String simpleName) {
        if (simpleName == null) {
            return null;
        }
        return this.nodeEngine.getConfig().findCacheConfig(simpleName);
    }

    @Override
    public Collection<CacheConfig> getCacheConfigs() {
        return this.configs.values();
    }

    public Object toObject(Object data) {
        if (data == null) {
            return null;
        }
        if (data instanceof Data) {
            return this.nodeEngine.toObject(data);
        }
        return data;
    }

    public Data toData(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof Data) {
            return (Data)object;
        }
        return this.nodeEngine.getSerializationService().toData(object);
    }

    @Override
    public void publishEvent(CacheEventContext cacheEventContext) {
        this.cacheEventHandler.publishEvent(cacheEventContext);
    }

    @Override
    public void publishEvent(String cacheName, CacheEventSet eventSet, int orderKey) {
        this.cacheEventHandler.publishEvent(cacheName, eventSet, orderKey);
    }

    @Override
    public NodeEngine getNodeEngine() {
        return this.nodeEngine;
    }

    @Override
    public void dispatchEvent(Object event, CacheEventListener listener) {
        listener.handleEvent(event);
    }

    @Override
    public String registerListener(String name, CacheEventListener listener, boolean isLocal) {
        return this.registerListenerInternal(name, listener, null, isLocal);
    }

    @Override
    public String registerListener(String name, CacheEventListener listener, EventFilter eventFilter, boolean isLocal) {
        return this.registerListenerInternal(name, listener, eventFilter, isLocal);
    }

    protected String registerListenerInternal(String name, CacheEventListener listener, EventFilter eventFilter, boolean isLocal) {
        CacheEntryListener cacheEntryListener;
        EventService eventService = this.getNodeEngine().getEventService();
        EventRegistration reg = isLocal ? (eventFilter == null ? eventService.registerLocalListener("hz:impl:cacheService", name, listener) : eventService.registerLocalListener("hz:impl:cacheService", name, eventFilter, listener)) : (eventFilter == null ? eventService.registerListener("hz:impl:cacheService", name, listener) : eventService.registerListener("hz:impl:cacheService", name, eventFilter, listener));
        String id = reg.getId();
        if (listener instanceof Closeable) {
            this.closeableListeners.put(id, (Closeable)((Object)listener));
        } else if (listener instanceof CacheEntryListenerProvider && (cacheEntryListener = ((CacheEntryListenerProvider)((Object)listener)).getCacheEntryListener()) instanceof Closeable) {
            this.closeableListeners.put(id, (Closeable)cacheEntryListener);
        }
        return id;
    }

    @Override
    public boolean deregisterListener(String name, String registrationId) {
        EventService eventService = this.getNodeEngine().getEventService();
        boolean result = eventService.deregisterListener("hz:impl:cacheService", name, registrationId);
        Closeable listener = (Closeable)this.closeableListeners.remove(registrationId);
        if (listener != null) {
            IOUtil.closeResource(listener);
        }
        return result;
    }

    @Override
    public void deregisterAllListener(String name) {
        EventService eventService = this.getNodeEngine().getEventService();
        Collection<EventRegistration> registrations = eventService.getRegistrations("hz:impl:cacheService", name);
        if (registrations != null) {
            for (EventRegistration registration : registrations) {
                Closeable listener = (Closeable)this.closeableListeners.remove(registration.getId());
                if (listener == null) continue;
                IOUtil.closeResource(listener);
            }
        }
        eventService.deregisterAllListeners("hz:impl:cacheService", name);
        CacheContext cacheContext = (CacheContext)this.cacheContexts.get(name);
        if (cacheContext != null) {
            cacheContext.resetCacheEntryListenerCount();
            cacheContext.resetInvalidationListenerCount();
        }
    }

    @Override
    public CacheStatisticsImpl getStatistics(String name) {
        return (CacheStatisticsImpl)this.statistics.get(name);
    }

    @Override
    public CacheOperationProvider getCacheOperationProvider(String nameWithPrefix, InMemoryFormat inMemoryFormat) {
        if (InMemoryFormat.NATIVE.equals((Object)inMemoryFormat)) {
            throw new IllegalArgumentException("Native memory is available only in Hazelcast Enterprise.Make sure you have Hazelcast Enterprise JARs on your classpath!");
        }
        CacheOperationProvider cacheOperationProvider = (CacheOperationProvider)this.operationProviderCache.get(nameWithPrefix);
        if (cacheOperationProvider != null) {
            return cacheOperationProvider;
        }
        cacheOperationProvider = this.createOperationProvider(nameWithPrefix, inMemoryFormat);
        CacheOperationProvider current = this.operationProviderCache.putIfAbsent(nameWithPrefix, cacheOperationProvider);
        return current == null ? cacheOperationProvider : current;
    }

    protected abstract CacheOperationProvider createOperationProvider(String var1, InMemoryFormat var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressFBWarnings(value={"JLM_JSR166_UTILCONCURRENT_MONITORENTER"}, justification="several ops performed on concurrent map, need synchronization for atomicity")
    public void addCacheResource(String name, Closeable resource) {
        Set cacheResources = (Set)this.resources.get(name);
        if (cacheResources == null) {
            ConcurrentMap<String, Set<Closeable>> concurrentMap = this.resources;
            synchronized (concurrentMap) {
                cacheResources = (Set)this.resources.get(name);
                if (cacheResources == null) {
                    cacheResources = Collections.newSetFromMap(new ConcurrentHashMap());
                    this.resources.put(name, cacheResources);
                }
            }
        }
        cacheResources.add(resource);
    }

    private void deleteCacheResources(String name) {
        Set cacheResources = (Set)this.resources.remove(name);
        if (cacheResources != null) {
            for (Closeable resource : cacheResources) {
                IOUtil.closeResource(resource);
            }
            cacheResources.clear();
        }
    }

    @Override
    public Operation getPostJoinOperation() {
        PostJoinCacheOperation postJoinCacheOperation = new PostJoinCacheOperation();
        for (Map.Entry cacheConfigEntry : this.configs.entrySet()) {
            postJoinCacheOperation.addCacheConfig((CacheConfig)cacheConfigEntry.getValue());
        }
        return postJoinCacheOperation;
    }

    protected void publishCachePartitionLostEvent(String cacheName, int partitionId) {
        LinkedList<EventRegistration> registrations = new LinkedList<EventRegistration>();
        for (EventRegistration registration : this.getRegistrations(cacheName)) {
            if (!(registration.getFilter() instanceof CachePartitionLostEventFilter)) continue;
            registrations.add(registration);
        }
        if (registrations.isEmpty()) {
            return;
        }
        Member member = this.nodeEngine.getLocalMember();
        CachePartitionEventData eventData = new CachePartitionEventData(cacheName, partitionId, member);
        EventService eventService = this.nodeEngine.getEventService();
        eventService.publishEvent("hz:impl:cacheService", registrations, (Object)eventData, partitionId);
    }

    Collection<EventRegistration> getRegistrations(String cacheName) {
        EventService eventService = this.nodeEngine.getEventService();
        return eventService.getRegistrations("hz:impl:cacheService", cacheName);
    }

    @Override
    public void onPartitionLost(InternalPartitionLostEvent partitionLostEvent) {
        int partitionId = partitionLostEvent.getPartitionId();
        for (CacheConfig config : this.getCacheConfigs()) {
            String cacheName = config.getName();
            if (config.getBackupCount() > partitionLostEvent.getLostReplicaIndex()) continue;
            this.publishCachePartitionLostEvent(cacheName, partitionId);
        }
    }

    public void cacheEntryListenerRegistered(String name, CacheEntryListenerConfiguration cacheEntryListenerConfiguration) {
        CacheConfig cacheConfig = this.getCacheConfig(name);
        if (cacheConfig == null) {
            throw new IllegalStateException("CacheConfig does not exist for cache " + name);
        }
        cacheConfig.addCacheEntryListenerConfiguration(cacheEntryListenerConfiguration);
    }

    public void cacheEntryListenerDeregistered(String name, CacheEntryListenerConfiguration cacheEntryListenerConfiguration) {
        CacheConfig cacheConfig = this.getCacheConfig(name);
        if (cacheConfig == null) {
            throw new IllegalStateException("CacheConfig does not exist for cache " + name);
        }
        cacheConfig.removeCacheEntryListenerConfiguration(cacheEntryListenerConfiguration);
    }

    @Override
    public String getQuorumName(String cacheName) {
        if (this.configs.get(cacheName) == null) {
            return null;
        }
        return ((CacheConfig)this.configs.get(cacheName)).getQuorumName();
    }

    @Override
    public String addInvalidationListener(String name, CacheEventListener listener, boolean localOnly) {
        EventService eventService = this.nodeEngine.getEventService();
        EventRegistration registration = localOnly ? eventService.registerLocalListener("hz:impl:cacheService", name, listener) : eventService.registerListener("hz:impl:cacheService", name, listener);
        return registration.getId();
    }

    @Override
    public void sendInvalidationEvent(String name, Data key, String sourceUuid) {
        this.cacheEventHandler.sendInvalidationEvent(name, key, sourceUuid);
    }

    @Override
    public Runnable prepareMergeRunnable() {
        return this.cacheSplitBrainHandler.prepareMergeRunnable();
    }
}

