/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl;

import com.hazelcast.cache.impl.nearcache.NearCacheManager;
import com.hazelcast.cache.impl.nearcache.impl.DefaultNearCacheManager;
import com.hazelcast.client.ClientExtension;
import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.client.impl.HazelcastClientInstanceImpl;
import com.hazelcast.client.impl.HazelcastClientManagedContext;
import com.hazelcast.client.proxy.ClientMapProxy;
import com.hazelcast.client.proxy.NearCachedClientMapProxy;
import com.hazelcast.client.spi.ClientProxy;
import com.hazelcast.client.spi.ClientProxyFactory;
import com.hazelcast.config.NearCacheConfig;
import com.hazelcast.config.SerializationConfig;
import com.hazelcast.core.PartitioningStrategy;
import com.hazelcast.instance.GroupProperty;
import com.hazelcast.internal.serialization.SerializationService;
import com.hazelcast.internal.serialization.impl.DefaultSerializationServiceBuilder;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import com.hazelcast.map.impl.MapConfigValidator;
import com.hazelcast.map.impl.MapService;
import com.hazelcast.nio.ClassLoaderUtil;
import com.hazelcast.nio.SocketInterceptor;
import com.hazelcast.nio.tcp.DefaultSocketChannelWrapperFactory;
import com.hazelcast.nio.tcp.SocketChannelWrapperFactory;
import com.hazelcast.partition.strategy.DefaultPartitioningStrategy;
import com.hazelcast.util.ExceptionUtil;

public class DefaultClientExtension
implements ClientExtension {
    protected static final ILogger LOGGER = Logger.getLogger(ClientExtension.class);
    protected volatile HazelcastClientInstanceImpl client;

    @Override
    public void beforeStart(HazelcastClientInstanceImpl client) {
        this.client = client;
    }

    @Override
    public void afterStart(HazelcastClientInstanceImpl client) {
    }

    @Override
    public SerializationService createSerializationService(byte version) {
        SerializationService ss;
        try {
            SerializationConfig serializationConfig;
            ClientConfig config = this.client.getClientConfig();
            ClassLoader configClassLoader = config.getClassLoader();
            HazelcastClientInstanceImpl hazelcastInstance = this.client;
            PartitioningStrategy partitioningStrategy = this.getPartitioningStrategy(configClassLoader);
            DefaultSerializationServiceBuilder builder = new DefaultSerializationServiceBuilder();
            SerializationConfig serializationConfig2 = serializationConfig = config.getSerializationConfig() != null ? config.getSerializationConfig() : new SerializationConfig();
            if (version > 0) {
                builder.setVersion(version);
            }
            ss = builder.setClassLoader(configClassLoader).setConfig(serializationConfig).setManagedContext(new HazelcastClientManagedContext(this.client, config.getManagedContext())).setPartitioningStrategy(partitioningStrategy).setHazelcastInstance(hazelcastInstance).build();
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow(e);
        }
        return ss;
    }

    protected PartitioningStrategy getPartitioningStrategy(ClassLoader configClassLoader) throws Exception {
        String partitioningStrategyClassName = GroupProperty.PARTITIONING_STRATEGY_CLASS.getSystemProperty();
        if (partitioningStrategyClassName != null && partitioningStrategyClassName.length() > 0) {
            return (PartitioningStrategy)ClassLoaderUtil.newInstance(configClassLoader, partitioningStrategyClassName);
        }
        return new DefaultPartitioningStrategy();
    }

    @Override
    public SocketInterceptor createSocketInterceptor() {
        LOGGER.warning("SocketInterceptor feature is only available on Hazelcast Enterprise!");
        return null;
    }

    @Override
    public SocketChannelWrapperFactory createSocketChannelWrapperFactory() {
        return new DefaultSocketChannelWrapperFactory();
    }

    @Override
    public <T> ClientProxyFactory createServiceProxyFactory(Class<T> service) {
        if (MapService.class.isAssignableFrom(service)) {
            return this.createClientMapProxyFactory();
        }
        throw new IllegalArgumentException("Proxy factory cannot be created. Unknown service : " + service);
    }

    private ClientProxyFactory createClientMapProxyFactory() {
        return new ClientProxyFactory(){

            @Override
            public ClientProxy create(String id) {
                NearCacheConfig nearCacheConfig = DefaultClientExtension.this.client.getClientConfig().getNearCacheConfig(id);
                if (nearCacheConfig != null) {
                    MapConfigValidator.checkInMemoryFormat(nearCacheConfig.getInMemoryFormat());
                    return new NearCachedClientMapProxy("hz:impl:mapService", id);
                }
                return new ClientMapProxy("hz:impl:mapService", id);
            }
        };
    }

    @Override
    public NearCacheManager createNearCacheManager() {
        return new DefaultNearCacheManager();
    }
}

