/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.client;

import com.hazelcast.client.impl.client.BaseClientAddListenerRequest;
import com.hazelcast.client.impl.client.ClientPortableHook;
import com.hazelcast.cluster.ClusterService;
import com.hazelcast.core.DistributedObjectEvent;
import com.hazelcast.core.DistributedObjectListener;
import com.hazelcast.spi.ProxyService;
import com.hazelcast.spi.impl.PortableDistributedObjectEvent;
import java.security.Permission;
import java.util.concurrent.Callable;

public class AddDistributedObjectListenerRequest
extends BaseClientAddListenerRequest
implements DistributedObjectListener {
    public Object call() throws Exception {
        final ProxyService proxyService = this.clientEngine.getProxyService();
        final String registrationId = proxyService.addProxyListener(this);
        this.endpoint.addDestroyAction(registrationId, new Callable(){

            public Boolean call() {
                return proxyService.removeProxyListener(registrationId);
            }
        });
        return registrationId;
    }

    @Override
    public String getServiceName() {
        return "hz:core:proxyService";
    }

    @Override
    public int getFactoryId() {
        return ClientPortableHook.ID;
    }

    @Override
    public int getClassId() {
        return 9;
    }

    @Override
    public void distributedObjectCreated(DistributedObjectEvent event) {
        this.send(event);
    }

    @Override
    public void distributedObjectDestroyed(DistributedObjectEvent event) {
        this.send(event);
    }

    private void send(DistributedObjectEvent event) {
        if (!this.shouldSendEvent()) {
            return;
        }
        PortableDistributedObjectEvent portableEvent = new PortableDistributedObjectEvent(event.getEventType(), (String)event.getObjectName(), event.getServiceName());
        this.endpoint.sendEvent(null, portableEvent, this.getCallId());
    }

    private boolean shouldSendEvent() {
        if (!this.endpoint.isAlive()) {
            return false;
        }
        ClusterService clusterService = this.clientEngine.getClusterService();
        boolean currentMemberIsMaster = clusterService.getMasterAddress().equals(this.clientEngine.getThisAddress());
        return !this.localOnly || currentMemberIsMaster;
    }

    @Override
    public Permission getRequiredPermission() {
        return null;
    }

    @Override
    public String getMethodName() {
        return "addDistributedObjectListener";
    }
}

