/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.proxy.txn;

import com.hazelcast.client.connection.nio.ClientConnection;
import com.hazelcast.client.impl.HazelcastClientInstanceImpl;
import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.ClientDestroyProxyCodec;
import com.hazelcast.client.spi.ClientTransactionContext;
import com.hazelcast.client.spi.impl.ClientInvocation;
import com.hazelcast.client.spi.impl.ClientInvocationFuture;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.partition.strategy.StringPartitioningStrategy;
import com.hazelcast.transaction.TransactionalObject;
import com.hazelcast.util.ExceptionUtil;

abstract class ClientTxnProxy
implements TransactionalObject {
    final String name;
    final ClientTransactionContext transactionContext;

    ClientTxnProxy(String name, ClientTransactionContext transactionContext) {
        this.name = name;
        this.transactionContext = transactionContext;
    }

    final ClientMessage invoke(ClientMessage request) {
        try {
            HazelcastClientInstanceImpl client = this.transactionContext.getClient();
            ClientConnection connection = this.transactionContext.getConnection();
            ClientInvocation invocation = new ClientInvocation(client, request, connection);
            ClientInvocationFuture future = invocation.invoke();
            return (ClientMessage)future.get();
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow(e);
        }
    }

    protected String getTransactionId() {
        return this.transactionContext.getTxnId();
    }

    abstract void onDestroy();

    @Override
    public final void destroy() {
        this.onDestroy();
        ClientMessage request = ClientDestroyProxyCodec.encodeRequest(this.name, this.getServiceName());
        this.invoke(request);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getPartitionKey() {
        return StringPartitioningStrategy.getPartitionKey(this.name);
    }

    Data toData(Object obj) {
        return this.transactionContext.getClient().getSerializationService().toData(obj);
    }

    Object toObject(Data data) {
        return this.transactionContext.getClient().getSerializationService().toObject(data);
    }
}

