/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.collection.impl.queue;

import com.hazelcast.config.QueueStoreConfig;
import com.hazelcast.core.HazelcastException;
import com.hazelcast.core.QueueStore;
import com.hazelcast.core.QueueStoreFactory;
import com.hazelcast.internal.serialization.SerializationService;
import com.hazelcast.nio.BufferObjectDataInput;
import com.hazelcast.nio.BufferObjectDataOutput;
import com.hazelcast.nio.ClassLoaderUtil;
import com.hazelcast.nio.IOUtil;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.util.EmptyStatement;
import com.hazelcast.util.Preconditions;
import com.hazelcast.util.QuickMath;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public final class QueueStoreWrapper
implements QueueStore<Data> {
    private static final int DEFAULT_MEMORY_LIMIT = 1000;
    private static final int DEFAULT_BULK_LOAD = 250;
    private static final int OUTPUT_SIZE = 1024;
    private static final int BUFFER_SIZE_FACTOR = 8;
    private static final String STORE_BINARY = "binary";
    private static final String STORE_MEMORY_LIMIT = "memory-limit";
    private static final String STORE_BULK_LOAD = "bulk-load";
    private int memoryLimit = 1000;
    private int bulkLoad = 250;
    private boolean enabled;
    private boolean binary;
    private QueueStore store;
    private SerializationService serializationService;

    private QueueStoreWrapper() {
    }

    public static QueueStoreWrapper create(String name, QueueStoreConfig storeConfig, SerializationService serializationService) {
        Preconditions.checkNotNull(name, "name should not be null");
        Preconditions.checkNotNull(serializationService, "serializationService should not be null");
        QueueStoreWrapper storeWrapper = new QueueStoreWrapper();
        storeWrapper.setSerializationService(serializationService);
        if (storeConfig == null || !storeConfig.isEnabled()) {
            return storeWrapper;
        }
        ClassLoader classLoader = serializationService.getClassLoader();
        QueueStore queueStore = QueueStoreWrapper.createQueueStore(name, storeConfig, classLoader);
        if (queueStore != null) {
            storeWrapper.setEnabled(storeConfig.isEnabled());
            storeWrapper.setBinary(Boolean.parseBoolean(storeConfig.getProperty(STORE_BINARY)));
            storeWrapper.setMemoryLimit(QueueStoreWrapper.parseInt(STORE_MEMORY_LIMIT, 1000, storeConfig));
            storeWrapper.setBulkLoad(QueueStoreWrapper.parseInt(STORE_BULK_LOAD, 250, storeConfig));
            storeWrapper.setStore(queueStore);
        }
        return storeWrapper;
    }

    private static QueueStore createQueueStore(String name, QueueStoreConfig storeConfig, ClassLoader classLoader) {
        QueueStore store = QueueStoreWrapper.getQueueStore(storeConfig, classLoader);
        if (store == null) {
            store = QueueStoreWrapper.getQueueStoreFactory(name, storeConfig, classLoader);
        }
        return store;
    }

    private static QueueStore getQueueStore(QueueStoreConfig storeConfig, ClassLoader classLoader) {
        if (storeConfig == null) {
            return null;
        }
        QueueStore store = storeConfig.getStoreImplementation();
        if (store != null) {
            return store;
        }
        try {
            store = (QueueStore)ClassLoaderUtil.newInstance(classLoader, storeConfig.getClassName());
        }
        catch (Exception ignored) {
            EmptyStatement.ignore(ignored);
        }
        return store;
    }

    private static QueueStore getQueueStoreFactory(String name, QueueStoreConfig storeConfig, ClassLoader classLoader) {
        if (storeConfig == null) {
            return null;
        }
        QueueStoreFactory factory = storeConfig.getFactoryImplementation();
        if (factory == null) {
            try {
                factory = (QueueStoreFactory)ClassLoaderUtil.newInstance(classLoader, storeConfig.getFactoryClassName());
            }
            catch (Exception ignored) {
                EmptyStatement.ignore(ignored);
            }
        }
        return factory == null ? null : factory.newQueueStore(name, storeConfig.getProperties());
    }

    @Override
    public void store(Long key, Data value) {
        Object actualValue;
        if (!this.enabled) {
            return;
        }
        if (this.binary) {
            int size = QuickMath.normalize(value.dataSize(), 8);
            BufferObjectDataOutput out = this.serializationService.createObjectDataOutput(size);
            try {
                out.writeData(value);
                actualValue = out.toByteArray();
            }
            catch (IOException e) {
                throw new HazelcastException(e);
            }
            finally {
                IOUtil.closeResource(out);
            }
        } else {
            actualValue = this.serializationService.toObject(value);
        }
        this.store.store(key, actualValue);
    }

    @Override
    public void storeAll(Map<Long, Data> map) {
        if (!this.enabled) {
            return;
        }
        HashMap<Long, Object> objectMap = new HashMap<Long, Object>(map.size());
        if (this.binary) {
            BufferObjectDataOutput out = this.serializationService.createObjectDataOutput(1024);
            try {
                for (Map.Entry<Long, Data> entry : map.entrySet()) {
                    out.writeData(entry.getValue());
                    objectMap.put(entry.getKey(), out.toByteArray());
                    out.clear();
                }
            }
            catch (IOException e) {
                throw new HazelcastException(e);
            }
            finally {
                IOUtil.closeResource(out);
            }
        } else {
            for (Map.Entry<Long, Data> entry : map.entrySet()) {
                objectMap.put(entry.getKey(), this.serializationService.toObject(entry.getValue()));
            }
        }
        this.store.storeAll(objectMap);
    }

    @Override
    public void delete(Long key) {
        if (this.enabled) {
            this.store.delete(key);
        }
    }

    @Override
    public void deleteAll(Collection<Long> keys) {
        if (this.enabled) {
            this.store.deleteAll(keys);
        }
    }

    @Override
    public Data load(Long key) {
        if (!this.enabled) {
            return null;
        }
        Object val = this.store.load(key);
        if (this.binary) {
            Data data;
            byte[] dataBuffer = (byte[])val;
            BufferObjectDataInput in = this.serializationService.createObjectDataInput(dataBuffer);
            try {
                data = in.readData();
            }
            catch (IOException e) {
                throw new HazelcastException(e);
            }
            return data;
        }
        return this.serializationService.toData(val);
    }

    @Override
    public Map<Long, Data> loadAll(Collection<Long> keys) {
        if (!this.enabled) {
            return null;
        }
        Map map = this.store.loadAll(keys);
        if (map == null) {
            return Collections.emptyMap();
        }
        HashMap<Long, Data> dataMap = new HashMap<Long, Data>(map.size());
        if (this.binary) {
            for (Map.Entry entry : map.entrySet()) {
                Data data;
                byte[] dataBuffer = (byte[])entry.getValue();
                BufferObjectDataInput in = this.serializationService.createObjectDataInput(dataBuffer);
                try {
                    data = in.readData();
                }
                catch (IOException e) {
                    throw new HazelcastException(e);
                }
                dataMap.put(entry.getKey(), data);
            }
        } else {
            for (Map.Entry entry : map.entrySet()) {
                dataMap.put(entry.getKey(), (Data)this.serializationService.toData(entry.getValue()));
            }
        }
        return dataMap;
    }

    @Override
    public Set<Long> loadAllKeys() {
        if (this.enabled) {
            return this.store.loadAllKeys();
        }
        return null;
    }

    private static int parseInt(String name, int defaultValue, QueueStoreConfig storeConfig) {
        String val = storeConfig.getProperty(name);
        if (val == null || val.trim().isEmpty()) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(val);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean isBinary() {
        return this.binary;
    }

    public int getMemoryLimit() {
        return this.memoryLimit;
    }

    public int getBulkLoad() {
        return this.bulkLoad;
    }

    void setSerializationService(SerializationService serializationService) {
        this.serializationService = serializationService;
    }

    void setStore(QueueStore store) {
        this.store = store;
    }

    void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    void setMemoryLimit(int memoryLimit) {
        this.memoryLimit = memoryLimit;
    }

    void setBulkLoad(int bulkLoad) {
        if (bulkLoad < 1) {
            bulkLoad = 1;
        }
        this.bulkLoad = bulkLoad;
    }

    void setBinary(boolean binary) {
        this.binary = binary;
    }
}

