/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.collection.impl.txnqueue;

import com.hazelcast.collection.impl.txnqueue.TransactionLogRecordKey;
import com.hazelcast.collection.impl.txnqueue.operations.TxnPollOperation;
import com.hazelcast.collection.impl.txnqueue.operations.TxnPrepareOperation;
import com.hazelcast.collection.impl.txnqueue.operations.TxnRollbackOperation;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.spi.Operation;
import com.hazelcast.transaction.impl.TransactionLogRecord;
import java.io.IOException;

public class QueueTransactionLogRecord
implements TransactionLogRecord {
    private long itemId;
    private String name;
    private Operation op;
    private int partitionId;
    private String transactionId;

    public QueueTransactionLogRecord() {
    }

    public QueueTransactionLogRecord(String transactionId, long itemId, String name, int partitionId, Operation op) {
        this.transactionId = transactionId;
        this.itemId = itemId;
        this.name = name;
        this.partitionId = partitionId;
        this.op = op;
    }

    @Override
    public Operation newPrepareOperation() {
        boolean pollOperation = this.op instanceof TxnPollOperation;
        return new TxnPrepareOperation(this.partitionId, this.name, this.itemId, pollOperation, this.transactionId);
    }

    @Override
    public Operation newCommitOperation() {
        this.op.setPartitionId(this.partitionId);
        return this.op;
    }

    @Override
    public Operation newRollbackOperation() {
        boolean pollOperation = this.op instanceof TxnPollOperation;
        return new TxnRollbackOperation(this.partitionId, this.name, this.itemId, pollOperation);
    }

    @Override
    public Object getKey() {
        return new TransactionLogRecordKey(this.itemId, this.name);
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeUTF(this.transactionId);
        out.writeLong(this.itemId);
        out.writeUTF(this.name);
        out.writeInt(this.partitionId);
        out.writeObject(this.op);
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        this.transactionId = in.readUTF();
        this.itemId = in.readLong();
        this.name = in.readUTF();
        this.partitionId = in.readInt();
        this.op = (Operation)in.readObject();
    }
}

