/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.concurrent.atomicreference;

import com.hazelcast.concurrent.atomicreference.AtomicReferenceContainer;
import com.hazelcast.concurrent.atomicreference.AtomicReferenceProxy;
import com.hazelcast.concurrent.atomicreference.operations.AtomicReferenceReplicationOperation;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.partition.InternalPartitionService;
import com.hazelcast.partition.MigrationEndpoint;
import com.hazelcast.partition.strategy.StringPartitioningStrategy;
import com.hazelcast.spi.ManagedService;
import com.hazelcast.spi.MigrationAwareService;
import com.hazelcast.spi.NodeEngine;
import com.hazelcast.spi.Operation;
import com.hazelcast.spi.PartitionMigrationEvent;
import com.hazelcast.spi.PartitionReplicationEvent;
import com.hazelcast.spi.RemoteService;
import com.hazelcast.util.ConcurrencyUtil;
import com.hazelcast.util.ConstructorFunction;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class AtomicReferenceService
implements ManagedService,
RemoteService,
MigrationAwareService {
    public static final String SERVICE_NAME = "hz:impl:atomicReferenceService";
    private NodeEngine nodeEngine;
    private final ConcurrentMap<String, AtomicReferenceContainer> containers = new ConcurrentHashMap<String, AtomicReferenceContainer>();
    private final ConstructorFunction<String, AtomicReferenceContainer> atomicReferenceConstructorFunction = new ConstructorFunction<String, AtomicReferenceContainer>(){

        @Override
        public AtomicReferenceContainer createNew(String key) {
            return new AtomicReferenceContainer();
        }
    };

    public AtomicReferenceContainer getReferenceContainer(String name) {
        return ConcurrencyUtil.getOrPutIfAbsent(this.containers, name, this.atomicReferenceConstructorFunction);
    }

    @Override
    public void init(NodeEngine nodeEngine, Properties properties) {
        this.nodeEngine = nodeEngine;
    }

    @Override
    public void reset() {
        this.containers.clear();
    }

    @Override
    public void shutdown(boolean terminate) {
        this.reset();
    }

    @Override
    public AtomicReferenceProxy createDistributedObject(String name) {
        return new AtomicReferenceProxy(name, this.nodeEngine, this);
    }

    @Override
    public void destroyDistributedObject(String name) {
        this.containers.remove(name);
    }

    @Override
    public void beforeMigration(PartitionMigrationEvent partitionMigrationEvent) {
    }

    @Override
    public Operation prepareReplicationOperation(PartitionReplicationEvent event) {
        if (event.getReplicaIndex() > 1) {
            return null;
        }
        HashMap<String, Data> data = new HashMap<String, Data>();
        int partitionId = event.getPartitionId();
        for (String name : this.containers.keySet()) {
            if (partitionId != this.getPartitionId(name)) continue;
            AtomicReferenceContainer atomicReferenceContainer = (AtomicReferenceContainer)this.containers.get(name);
            Data value = atomicReferenceContainer.get();
            data.put(name, value);
        }
        return data.isEmpty() ? null : new AtomicReferenceReplicationOperation(data);
    }

    @Override
    public void commitMigration(PartitionMigrationEvent partitionMigrationEvent) {
        if (partitionMigrationEvent.getMigrationEndpoint() == MigrationEndpoint.SOURCE) {
            int partitionId = partitionMigrationEvent.getPartitionId();
            this.removeContainers(partitionId);
        }
    }

    @Override
    public void rollbackMigration(PartitionMigrationEvent partitionMigrationEvent) {
        if (partitionMigrationEvent.getMigrationEndpoint() == MigrationEndpoint.DESTINATION) {
            int partitionId = partitionMigrationEvent.getPartitionId();
            this.removeContainers(partitionId);
        }
    }

    @Override
    public void clearPartitionReplica(int partitionId) {
        this.removeContainers(partitionId);
    }

    public void removeContainers(int partitionId) {
        Iterator iterator = this.containers.keySet().iterator();
        while (iterator.hasNext()) {
            String name = (String)iterator.next();
            if (this.getPartitionId(name) != partitionId) continue;
            iterator.remove();
        }
    }

    private int getPartitionId(String name) {
        InternalPartitionService partitionService = this.nodeEngine.getPartitionService();
        String partitionKey = StringPartitioningStrategy.getPartitionKey(name);
        return partitionService.getPartitionId(partitionKey);
    }
}

